/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.jms.jdbc.JdbcManager;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.jms.queue.MessageException;
import com.caucho.jms.queue.PollingQueue;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.sql.DataSource;

public class JdbcQueue<E>
extends PollingQueue<E> {
    static final Logger log = Logger.getLogger(JdbcQueue.class.getName());
    static final L10N L = new L10N(JdbcQueue.class);
    protected JdbcManager _jdbcManager = new JdbcManager();
    private String _name;
    private int _id;
    private int _consumerId;

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getQueueName() {
        return this.getName();
    }

    @Override
    public void setQueueName(String name) {
        this.setName(name);
    }

    public int getId() {
        return this._id;
    }

    public void setJdbcManager(JdbcManager jdbcManager) {
        this._jdbcManager = jdbcManager;
    }

    public JdbcManager getJdbcManager() {
        return this._jdbcManager;
    }

    public void setDataSource(DataSource dataSource) {
        this._jdbcManager.setDataSource(dataSource);
    }

    public void setTablespace(String tablespace) {
        this._jdbcManager.setTablespace(tablespace);
    }

    @Override
    public void init() throws ConfigException {
        try {
            if (this._jdbcManager.getDataSource() == null) {
                throw new ConfigException(L.l("JdbcQueue requires a <data-source> element."));
            }
            if (this.getName() == null) {
                throw new ConfigException(L.l("JdbcQueue requires a <queue-name> element."));
            }
            this._jdbcManager.init();
            this._id = this.createDestination(this.getName(), false);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public void send(String msgId, E payload, int priority, long expireTime, String publisherId) throws MessageException {
    }

    public void commit(int session) throws JMSException {
    }

    protected int createDestination(String name, boolean isTopic) throws SQLException {
        Connection conn = this._jdbcManager.getDataSource().getConnection();
        String destinationTable = this._jdbcManager.getDestinationTable();
        String destinationSequence = this._jdbcManager.getDestinationSequence();
        try {
            String sql = "SELECT id FROM " + destinationTable + " WHERE name=? AND is_topic=?";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, name);
            pstmt.setInt(2, isTopic ? 1 : 0);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            rs.close();
            if (destinationSequence != null) {
                JdbcMetaData metaData = this._jdbcManager.getMetaData();
                sql = metaData.selectSequenceSQL(destinationSequence);
                int id = 0;
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                if (!rs.next()) {
                    throw new RuntimeException("can't create sequence");
                }
                id = rs.getInt(1);
                sql = "INSERT INTO " + destinationTable + " (id,name,is_topic) VALUES(?,?,?)";
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, id);
                pstmt.setString(2, name);
                pstmt.setInt(3, isTopic ? 1 : 0);
                pstmt.executeUpdate();
                if (isTopic) {
                    log.fine("JMSTopic[" + name + "," + id + "] created");
                } else {
                    log.fine("JMSQueue[" + name + "," + id + "] created");
                }
                int n = id;
                return n;
            }
            sql = "INSERT INTO " + destinationTable + " (name,is_topic) VALUES(?,?)";
            pstmt = conn.prepareStatement(sql, 1);
            pstmt.setString(1, name);
            pstmt.setInt(2, isTopic ? 1 : 0);
            pstmt.executeUpdate();
            rs = pstmt.getGeneratedKeys();
            if (rs.next()) {
                int id = rs.getInt(1);
                if (isTopic) {
                    log.fine("JMSTopic[" + name + "," + id + "] created");
                } else {
                    log.fine("JMSQueue[" + name + "," + id + "] created");
                }
                int n = id;
                return n;
            }
            throw new SQLException(L.l("can't generate destination for {0}", (Object)name));
        }
        finally {
            conn.close();
        }
    }

    protected void purgeExpiredMessages() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pollImpl() {
        boolean hasValue = false;
        try {
            long minId = -1L;
            DataSource dataSource = this._jdbcManager.getDataSource();
            String messageTable = this._jdbcManager.getMessageTable();
            JdbcMessage jdbcMessage = this._jdbcManager.getJdbcMessage();
            Connection conn = dataSource.getConnection();
            try {
                String sql = "SELECT m_id FROM " + messageTable + " WHERE ?<m_id AND queue=?   AND consumer IS NULL AND ?<=expire ORDER BY m_id";
                PreparedStatement selectStmt = conn.prepareStatement(sql);
                try {
                    selectStmt.setFetchSize(1);
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                selectStmt.setLong(1, minId);
                selectStmt.setInt(2, this.getId());
                selectStmt.setLong(3, CurrentTime.getCurrentTime());
                Object msg = null;
                ResultSet rs = selectStmt.executeQuery();
                if (rs.next()) {
                    hasValue = true;
                }
                rs.close();
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public String toString() {
        return "JdbcQueue[" + this.getName() + "]";
    }
}

