/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.selector;

import com.caucho.jms.selector.Selector;
import com.caucho.util.L10N;
import javax.jms.JMSException;
import javax.jms.Message;

public class UnarySelector
extends Selector {
    static L10N L = new L10N(Selector.class);
    private int _token;
    private Selector _expr;

    UnarySelector(int token, Selector expr) {
        this._token = token;
        this._expr = expr;
    }

    @Override
    boolean isBoolean() {
        switch (this._token) {
            case 3: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isNumber() {
        switch (this._token) {
            case 43: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isUnknown() {
        return false;
    }

    @Override
    Object evaluate(Message message) throws JMSException {
        Object value = this._expr.evaluate(message);
        switch (this._token) {
            case 15: {
                if (!(value instanceof Boolean)) {
                    return NULL;
                }
                return UnarySelector.toBoolean((Boolean)value == false);
            }
            case 3: {
                return UnarySelector.toBoolean(value == null);
            }
            case 43: {
                if (!(value instanceof Number)) {
                    return NULL;
                }
                return value;
            }
            case 45: {
                if (!(value instanceof Number)) {
                    return NULL;
                }
                if (UnarySelector.isInteger(value)) {
                    return new Long(-this.toLong(value));
                }
                return new Double(-((Number)value).doubleValue());
            }
        }
        throw new JMSException("NOTONE");
    }

    public String toString() {
        switch (this._token) {
            case 15: {
                return "not(" + this._expr + ")";
            }
            case 3: {
                return "(" + this._expr + " is null)";
            }
            case 43: {
                return "+ (" + this._expr + ")";
            }
            case 45: {
                return "- (" + this._expr + ")";
            }
        }
        return super.toString();
    }
}

