/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.Jmx;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class JmxInvocationHandler
implements InvocationHandler {
    private MBeanServer _server;
    private ClassLoader _loader;
    private ObjectName _name;

    public JmxInvocationHandler(MBeanServer mbeanServer, ClassLoader loader, ObjectName objectName) {
        this._server = mbeanServer;
        this._loader = loader;
        this._name = objectName;
    }

    public static Object newProxyInstance(MBeanServer server, ClassLoader loader, ObjectName objectName, Class interfaceClass, boolean notificationBroadcaster) {
        Class[] interfaces = notificationBroadcaster ? new Class[]{interfaceClass, NotificationEmitter.class} : new Class[]{interfaceClass};
        JmxInvocationHandler handler = new JmxInvocationHandler(server, loader, objectName);
        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(Object.class)) {
            Object value = args[0];
            if (value == null || !Proxy.isProxyClass(value.getClass())) {
                return Boolean.FALSE;
            }
            JmxInvocationHandler handler = (JmxInvocationHandler)Proxy.getInvocationHandler(value);
            return new Boolean(this._name.equals(handler._name));
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return new Integer(this._name.hashCode());
        }
        int len = methodName.length();
        Class<?> returnType = method.getReturnType();
        if (params.length == 0 && methodName.startsWith("get") && len > 3) {
            String attrName = methodName.substring(3);
            return this.marshall(this._server.getAttribute(this._name, attrName), returnType);
        }
        if (params.length == 1 && returnType.equals(Void.TYPE) && methodName.startsWith("set") && len > 3) {
            String attrName = methodName.substring(3);
            Attribute attr = new Attribute(attrName, args[0]);
            this._server.setAttribute(this._name, attr);
            return null;
        }
        if (methodName.equals("addNotificationListener")) {
            if (args.length == 3) {
                if (args[0] instanceof NotificationListener) {
                    this._server.addNotificationListener(this._name, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                    return null;
                }
                if (args[0] instanceof ObjectName) {
                    this._server.addNotificationListener(this._name, (ObjectName)args[0], (NotificationFilter)args[1], args[2]);
                    return null;
                }
            }
        } else if (methodName.equals("removeNotificationListener")) {
            if (args.length == 3) {
                if (args[0] instanceof NotificationListener) {
                    this._server.removeNotificationListener(this._name, (NotificationListener)args[0], (NotificationFilter)args[1], args[2]);
                    return null;
                }
                if (args[0] instanceof ObjectName) {
                    this._server.removeNotificationListener(this._name, (ObjectName)args[0], (NotificationFilter)args[1], args[2]);
                    return null;
                }
            } else if (args.length == 1) {
                if (args[0] instanceof NotificationListener) {
                    this._server.removeNotificationListener(this._name, (NotificationListener)args[0]);
                    return null;
                }
                if (args[0] instanceof ObjectName) {
                    this._server.removeNotificationListener(this._name, (ObjectName)args[0]);
                    return null;
                }
            }
        }
        String[] sig = new String[params.length];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = params[i].getName();
        }
        Object value = this._server.invoke(this._name, methodName, args, sig);
        return this.marshall(value, returnType);
    }

    private Object marshall(Object value, Class retType) {
        if (retType == null || value == null || retType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof ObjectName) {
            ObjectName name = (ObjectName)value;
            Object proxy = Jmx.find(name, this._loader, this._server);
            if (retType.isInstance(proxy)) {
                return proxy;
            }
            return value;
        }
        if (value instanceof ObjectName[] && retType.isArray()) {
            Class<?> type = retType.getComponentType();
            ObjectName[] names = (ObjectName[])value;
            Object proxies = Array.newInstance(type, names.length);
            for (int i = 0; i < names.length; ++i) {
                Object proxy = Jmx.find(names[i], this._loader, this._server);
                if (proxy == null) {
                    Array.set(proxies, i, null);
                    continue;
                }
                if (!type.isInstance(proxy)) {
                    return value;
                }
                Array.set(proxies, i, Jmx.find(names[i], this._loader, this._server));
            }
            return proxies;
        }
        return value;
    }
}

