/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.ClassLoaderRepositoryImpl;
import com.caucho.jmx.Jmx;
import com.caucho.jmx.MBeanView;
import com.caucho.jmx.MBeanWrapper;
import com.caucho.loader.CloseListener;
import com.caucho.loader.Environment;
import com.caucho.util.L10N;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;

public class MBeanContext {
    private static final Logger log = Logger.getLogger(MBeanContext.class.getName());
    private static final L10N L = new L10N(MBeanContext.class);
    private MBeanContext _parent;
    private AbstractMBeanServer _mbeanServer;
    private MBeanContext _globalContext;
    private MBeanServerDelegate _delegate;
    private long _seq;
    private ClassLoader _loader;
    private String _domain = "resin";
    private LinkedHashMap<String, String> _properties = new LinkedHashMap();
    private ClassLoaderRepositoryImpl _classLoaderRepository = new ClassLoaderRepositoryImpl();
    private Hashtable<ObjectName, MBeanWrapper> _mbeans = new Hashtable();
    private ArrayList<Listener> _listeners = new ArrayList();
    private MBeanView _view;
    private MBeanView _globalView;

    MBeanContext(AbstractMBeanServer mbeanServer, ClassLoader loader, MBeanServerDelegate delegate, MBeanContext globalContext) {
        loader = Environment.getEnvironmentClassLoader(loader);
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        this._mbeanServer = mbeanServer;
        this._loader = loader;
        this._delegate = delegate;
        this._globalContext = globalContext;
        this._mbeanServer.setCurrentContext(this, loader);
        Environment.addClassLoaderListener(new CloseListener(this), this._loader);
        this._classLoaderRepository.addClassLoader(this._loader);
        this._view = new MBeanView(mbeanServer, this._loader, "resin");
        this._globalView = new MBeanView(mbeanServer, this._loader, "resin");
        if (this._loader != null && this._loader != ClassLoader.getSystemClassLoader()) {
            this._parent = this._mbeanServer.createContext(this._loader.getParent());
            if (this._parent == this) {
                this._parent = null;
            }
        }
    }

    protected MBeanView getParentView() {
        return this._mbeanServer.getParentView();
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return this._classLoaderRepository;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    MBeanView getView() {
        return this._view;
    }

    MBeanView getGlobalView() {
        return this._globalView;
    }

    public void setProperties(Map<String, String> props) {
        this._properties.clear();
        this._properties.putAll(props);
    }

    public LinkedHashMap<String, String> copyProperties() {
        return new LinkedHashMap<String, String>(this._properties);
    }

    public ObjectName getObjectName(String name) throws MalformedObjectNameException {
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (ch == ':') {
                return new ObjectName(name);
            }
            if (!('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '_') && ch != '.') break;
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.putAll(this._properties);
        Jmx.parseProperties(properties, name);
        return Jmx.getObjectName(this._domain, properties);
    }

    MBeanWrapper getMBean(ObjectName name) {
        if (name != null) {
            return this._mbeans.get(name);
        }
        return null;
    }

    ObjectInstance registerMBean(MBeanWrapper mbean, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (mbean == null) {
            throw new NotCompliantMBeanException(L.l("{0} is a null mbean", (Object)name));
        }
        if (this._mbeans.get(name) != null) {
            throw new InstanceAlreadyExistsException(String.valueOf(name));
        }
        Object object = mbean.getObject();
        MBeanRegistration registration = null;
        if (object instanceof MBeanRegistration) {
            registration = (MBeanRegistration)object;
        }
        try {
            if (registration != null) {
                name = registration.preRegister(this._mbeanServer, name);
            }
        }
        catch (Exception e) {
            throw new MBeanRegistrationException(e);
        }
        if (log.isLoggable(Level.FINEST) && !name.equals(AbstractMBeanServer.SERVER_DELEGATE_NAME)) {
            log.finest(this.getDebugName(name, mbean) + " registered in " + this);
        }
        this.addMBean(name, mbean);
        try {
            if (registration != null) {
                registration.postRegister(new Boolean(true));
            }
        }
        catch (Exception e) {
            throw new MBeanRegistrationException(e);
        }
        if (this._globalContext != null) {
            this._globalContext.addMBean(name, mbean);
        }
        return mbean.getObjectInstance();
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this._mbeans == null) {
            this.removeMBean(name);
            return;
        }
        if (name.getDomain().equals("JMImplementation")) {
            return;
        }
        MBeanWrapper mbean = this._mbeans.get(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        Object obj = mbean.getObject();
        MBeanRegistration registration = null;
        if (obj instanceof MBeanRegistration) {
            registration = (MBeanRegistration)obj;
        }
        try {
            if (registration != null) {
                try {
                    registration.preDeregister();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString());
                }
            }
            this.removeMBean(name);
            if (registration != null) {
                try {
                    registration.postDeregister();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString());
                }
            }
        }
        catch (Exception e) {
            throw new MBeanRegistrationException(e);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        MBeanWrapper mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.getObjectInstance();
    }

    public boolean isRegistered(ObjectName name) {
        return this._mbeans.get(name) != null;
    }

    public int getMBeanCount() {
        return this._mbeans.size();
    }

    private void addMBean(ObjectName name, MBeanWrapper mbean) {
        if (this._mbeans == null) {
            throw new IllegalStateException(L.l("Adding MBean when context is closed"));
        }
        if (mbean == null) {
            log.warning(L.l("'{0}' is an empty mbean", (Object)name));
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.getDebugName(name, mbean) + " registered in " + this);
        }
        this._mbeans.put(name, mbean);
        this._view.add(name, mbean, true);
        this._globalView.add(name, mbean, true);
        this.sendRegisterNotification(name);
        MBeanContext parentContext = this._parent;
        while (parentContext != null) {
            if (parentContext._globalView == null) {
                log.finer("global view is empty");
            } else if (parentContext._globalView.add(name, mbean, false)) {
                parentContext.sendRegisterNotification(name);
            }
            parentContext = parentContext._parent;
        }
    }

    private MBeanWrapper removeMBean(ObjectName name) {
        MBeanWrapper mbean = null;
        if (this._mbeans != null) {
            mbean = this._mbeans.remove(name);
        }
        if (this._globalContext != null && this._globalContext._mbeans != null) {
            this._globalContext._mbeans.remove(name);
        }
        if (this._view != null) {
            this._view.remove(name);
        }
        if (this._globalView != null && this._globalView.remove(name) != null) {
            try {
                this.sendUnregisterNotification(name);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (this._parent != null) {
            this._parent.removeMBean(name);
        }
        return mbean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        ArrayList<Listener> arrayList = this._listeners;
        synchronized (arrayList) {
            this._listeners.add(new Listener(name, listener, filter, handback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName mbean, NotificationListener listener) {
        ArrayList<Listener> arrayList = this._listeners;
        synchronized (arrayList) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                Listener oldListener = this._listeners.get(i);
                if (!oldListener.match(mbean, listener)) continue;
                this._listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName mbean, NotificationListener listener, NotificationFilter filter, Object handback) {
        ArrayList<Listener> arrayList = this._listeners;
        synchronized (arrayList) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                Listener oldListener = this._listeners.get(i);
                if (!oldListener.match(mbean, listener, filter, handback)) continue;
                this._listeners.remove(i);
            }
        }
    }

    void sendRegisterNotification(ObjectName name) {
        this.serverNotification(name, "JMX.mbean.registered");
    }

    void sendUnregisterNotification(ObjectName name) {
        this.serverNotification(name, "JMX.mbean.unregistered");
    }

    private void serverNotification(ObjectName name, String type) {
        ObjectName delegateName = AbstractMBeanServer.SERVER_DELEGATE_NAME;
        MBeanServerNotification notif = new MBeanServerNotification(type, (Object)delegateName, this._seq++, name);
        this._delegate.sendNotification(notif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            int i;
            if (this._mbeans == null) {
                return;
            }
            log.finest(this + " destroy");
            ArrayList<ObjectName> list = new ArrayList<ObjectName>(this._mbeans.keySet());
            ArrayList<Listener> listeners = new ArrayList<Listener>(this._listeners);
            for (i = 0; i < listeners.size(); ++i) {
                Listener listener = listeners.get(i);
                try {
                    MBeanWrapper mbean = this._globalView.getMBean(listener.getName());
                    if (mbean == null) continue;
                    mbean.removeNotificationListener(listener.getListener(), listener.getFilter(), listener.getHandback());
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            for (i = 0; i < list.size(); ++i) {
                ObjectName name = list.get(i);
                try {
                    this.unregisterMBean(name);
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            this._mbeanServer.removeContext(this, this._loader);
        }
        finally {
            this._parent = null;
            this._mbeanServer = null;
            this._globalContext = null;
            this._delegate = null;
            this._loader = null;
            this._classLoaderRepository = null;
            this._mbeans = null;
            this._listeners = null;
            this._view = null;
            this._globalView = null;
        }
    }

    private String getDebugName(ObjectName name, MBeanWrapper mbean) {
        String className = mbean.getMBeanInfo().getClassName();
        int p = className.lastIndexOf(46);
        if (p > 0) {
            className = className.substring(p + 1);
        }
        return className + "[" + name + "]";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._loader + "]";
    }

    public class MBeanClose
    implements Closeable {
        private final ArrayList<ObjectName> _names = new ArrayList();

        public void addName(ObjectName name) {
            this._names.add(name);
        }

        public void removeName(ObjectName name) {
            this._names.add(name);
        }

        @Override
        public void close() {
            ArrayList<ObjectName> names = new ArrayList<ObjectName>(this._names);
            this._names.clear();
            for (ObjectName name : names) {
                try {
                    MBeanContext.this.unregisterMBean(name);
                }
                catch (Exception e) {
                    log.log(Level.FINEST, e.toString(), e);
                }
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class Listener {
        private ObjectName _name;
        private WeakReference<NotificationListener> _listenerRef;
        private WeakReference<NotificationFilter> _filterRef;
        private WeakReference<Object> _handbackRef;

        Listener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
            this._name = name;
            this._listenerRef = new WeakReference<NotificationListener>(listener);
            if (filter != null) {
                this._filterRef = new WeakReference<NotificationFilter>(filter);
            }
            if (handback != null) {
                this._handbackRef = new WeakReference<Object>(handback);
            }
        }

        ObjectName getName() {
            return this._name;
        }

        NotificationListener getListener() {
            return (NotificationListener)this._listenerRef.get();
        }

        NotificationFilter getFilter() {
            return this._filterRef != null ? (NotificationFilter)this._filterRef.get() : null;
        }

        Object getHandback() {
            return this._handbackRef != null ? this._handbackRef.get() : null;
        }

        boolean match(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
            if (!this._name.equals(name)) {
                return false;
            }
            if (listener != this._listenerRef.get()) {
                return false;
            }
            if (filter == null && this._filterRef != null) {
                return false;
            }
            if (this._filterRef != null && this._filterRef.get() != filter) {
                return false;
            }
            if (handback == null && this._handbackRef != null) {
                return false;
            }
            return this._handbackRef == null || this._handbackRef.get() == handback;
        }

        boolean match(ObjectName name, NotificationListener listener) {
            if (!this._name.equals(name)) {
                return false;
            }
            return listener == this._listenerRef.get();
        }
    }
}

