/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.util.L10N;
import com.caucho.util.TimedCache;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;

public class BundleManager {
    private static final L10N L = new L10N(BundleManager.class);
    private static final Logger log = Logger.getLogger(BundleManager.class.getName());
    public static final LocalizationContext NULL_BUNDLE = new LocalizationContext();
    private static EnvironmentLocal<BundleManager> _envBundle = new EnvironmentLocal();
    private TimedCache<String, LocalizationContext> _bundleCache;
    private Method _bundleSetParentMethod;

    private BundleManager() {
        long updateInterval = Environment.getDependencyCheckInterval();
        this._bundleCache = new TimedCache(256, updateInterval);
        try {
            this._bundleSetParentMethod = ResourceBundle.class.getDeclaredMethod("setParent", ResourceBundle.class);
            this._bundleSetParentMethod.setAccessible(true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleManager create() {
        BundleManager manager;
        EnvironmentLocal<BundleManager> environmentLocal = _envBundle;
        synchronized (environmentLocal) {
            manager = _envBundle.get();
            if (manager == null) {
                manager = new BundleManager();
                _envBundle.set(manager);
            }
        }
        return manager;
    }

    public LocalizationContext getBundle(String name, String cacheKey, Enumeration<Locale> locales) {
        LocalizationContext cachedValue = this._bundleCache.get(cacheKey);
        if (cachedValue != null) {
            return cachedValue == NULL_BUNDLE ? null : cachedValue;
        }
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            LocalizationContext bundle = this.getBundle(name, locale);
            if (bundle == null) continue;
            this._bundleCache.put(cacheKey, bundle);
            return bundle;
        }
        this._bundleCache.put(cacheKey, NULL_BUNDLE);
        return null;
    }

    public LocalizationContext getBundle(String name, Locale locale) {
        String cacheName = name + '_' + locale.getLanguage() + '_' + locale.getCountry() + '_' + locale.getVariant();
        LocalizationContext context = this._bundleCache.get(cacheName);
        if (context != null) {
            return context != NULL_BUNDLE ? context : null;
        }
        ResourceBundle parent = this.getBaseBundle(name);
        ResourceBundle bundle = this.getBaseBundle(name + '_' + locale.getLanguage());
        ResourceBundle matchBundle = null;
        if (bundle != null) {
            if (parent != null) {
                try {
                    this._bundleSetParentMethod.invoke((Object)bundle, parent);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            parent = bundle;
            matchBundle = bundle;
        }
        if ((bundle = this.getBaseBundle(name + '_' + locale.getLanguage() + '_' + locale.getCountry())) != null) {
            if (parent != null) {
                try {
                    this._bundleSetParentMethod.invoke((Object)bundle, parent);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            parent = bundle;
            matchBundle = bundle;
        }
        if ((bundle = this.getBaseBundle(name + '_' + locale.getLanguage() + '_' + locale.getCountry() + '_' + locale.getVariant())) != null) {
            if (parent != null) {
                try {
                    this._bundleSetParentMethod.invoke((Object)bundle, parent);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
            }
            parent = bundle;
            matchBundle = bundle;
        }
        if (matchBundle != null) {
            context = new LocalizationContext(matchBundle, locale);
            this._bundleCache.put(cacheName, context);
            return context;
        }
        this._bundleCache.put(cacheName, NULL_BUNDLE);
        return null;
    }

    public LocalizationContext getBundle(String name) {
        if (name == null) {
            return null;
        }
        LocalizationContext bundle = this._bundleCache.get(name);
        if (bundle != null) {
            return bundle != NULL_BUNDLE ? bundle : null;
        }
        ResourceBundle resourceBundle = this.getBaseBundle(name);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle);
            this._bundleCache.put(name, bundle);
            return bundle;
        }
        this._bundleCache.put(name, NULL_BUNDLE);
        return null;
    }

    private ResourceBundle getBaseBundle(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            ResourceBundle rb;
            Class<?> cl = Class.forName(name, false, loader);
            if (cl != null && (rb = (ResourceBundle)cl.newInstance()) != null) {
                return rb;
            }
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        try {
            InputStream is = loader.getResourceAsStream(name.replace('.', '/') + ".properties");
            if (is instanceof ReadStream) {
                Path path = ((ReadStream)is).getPath();
                Environment.addDependency(path.createDepend());
            }
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            is.close();
            return bundle;
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }
}

