/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaMethod;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.jsp.AnalyzedTag;
import com.caucho.util.L10N;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.EJBs;
import javax.inject.Inject;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public class TagAnalyzer {
    private static final Logger log = Logger.getLogger(TagAnalyzer.class.getName());
    private static final L10N L = new L10N(TagAnalyzer.class);
    private static Class<Annotation> _persistenceContext;
    private static Class<Annotation> _persistenceUnit;
    private HashMap<Class<?>, AnalyzedTag> _analyzedTags = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalyzedTag analyze(Class<?> tagClass) {
        if (tagClass == null) {
            return null;
        }
        AnalyzedTag analyzedTag = this._analyzedTags.get(tagClass);
        if (analyzedTag != null) {
            return analyzedTag;
        }
        if (!JspTag.class.isAssignableFrom(tagClass)) {
            return null;
        }
        if (tagClass.isInterface()) {
            return null;
        }
        AnalyzedTag parent = this.analyze(tagClass.getSuperclass());
        String name = tagClass.getName().replace('.', '/') + ".class";
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        AnalyzedTag tag = new AnalyzedTag();
        tag.setParent(parent);
        try {
            this.analyzeByReflection(tagClass, tag, parent);
            InputStream is = loader.getResourceAsStream(name);
            if (is == null) {
                return tag;
            }
            try {
                JavaClass javaClass = new ByteCodeParser().parse(is);
                tag.setJavaClass(javaClass);
                this.analyze(tag, "doStartTag", "()I", new StartAnalyzer(tag));
                this.analyze(tag, "doEndTag", "()I", new EndAnalyzer(tag));
                if (IterationTag.class.isAssignableFrom(tagClass)) {
                    this.analyze(tag, "doAfterBody", "()I", new AfterAnalyzer(tag));
                }
                if (BodyTag.class.isAssignableFrom(tagClass)) {
                    this.analyze(tag, "doInitBody", "()V", new InitAnalyzer());
                }
                if (TryCatchFinally.class.isAssignableFrom(tagClass)) {
                    this.analyze(tag, "doCatch", "(Ljava/lang/Throwable;)V", new CatchAnalyzer());
                    this.analyze(tag, "doFinally", "()V", new FinallyAnalyzer());
                }
            }
            finally {
                is.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return tag;
    }

    public void analyzeByReflection(Class<?> tagClass, AnalyzedTag tag, AnalyzedTag parent) {
        tag.setBodyTag(BodyTag.class.isAssignableFrom(tagClass));
        Method doStartMethod = this.getMethod(tagClass, "doStartTag", new Class[0]);
        if (doStartMethod != null && doStartMethod.getDeclaringClass().equals(tagClass)) {
            if (TagSupport.class.equals(tagClass)) {
                tag.setDoStart(false);
                tag.setStartReturnsSkip(false);
                tag.setStartReturnsInclude(true);
                tag.setStartReturnsBuffered(false);
            } else if (BodyTagSupport.class.equals(tagClass)) {
                tag.setDoStart(false);
                tag.setStartReturnsSkip(false);
                tag.setStartReturnsInclude(false);
                tag.setStartReturnsBuffered(true);
            } else if (BodyTag.class.isAssignableFrom(tagClass)) {
                tag.setDoStart(true);
                tag.setStartReturnsSkip(true);
                tag.setStartReturnsInclude(true);
                tag.setStartReturnsBuffered(true);
            } else {
                tag.setDoStart(true);
                tag.setStartReturnsSkip(true);
                tag.setStartReturnsInclude(true);
                tag.setStartReturnsBuffered(false);
            }
        } else if (parent != null) {
            tag.setDoStart(parent.getDoStart());
            tag.setStartReturnsSkip(parent.getStartReturnsSkip());
            tag.setStartReturnsInclude(parent.getStartReturnsInclude());
            tag.setStartReturnsBuffered(parent.getStartReturnsBufferedAsParent());
        }
        Method doEndMethod = this.getMethod(tagClass, "doEndTag", new Class[0]);
        if (doEndMethod != null && doEndMethod.getDeclaringClass().equals(tagClass)) {
            if (TagSupport.class.equals(tagClass) || BodyTagSupport.class.equals(tagClass)) {
                tag.setDoEnd(false);
                tag.setEndReturnsSkip(false);
                tag.setEndReturnsEval(true);
            } else {
                tag.setDoEnd(true);
                tag.setEndReturnsSkip(true);
                tag.setEndReturnsEval(true);
            }
        } else if (parent != null) {
            tag.setDoEnd(parent.getDoEnd());
            tag.setEndReturnsSkip(parent.getEndReturnsSkip());
            tag.setEndReturnsEval(parent.getEndReturnsEval());
        }
        Method doAfterBody = this.getMethod(tagClass, "doAfterBody", new Class[0]);
        if (doAfterBody != null && doAfterBody.getDeclaringClass().equals(tagClass)) {
            if (TagSupport.class.equals(tagClass) || BodyTagSupport.class.equals(tagClass)) {
                tag.setDoAfter(false);
                tag.setAfterReturnsAgain(false);
            } else if (!IterationTag.class.isAssignableFrom(tagClass)) {
                tag.setDoAfter(false);
                tag.setAfterReturnsAgain(false);
            } else {
                tag.setDoAfter(true);
                tag.setAfterReturnsAgain(true);
            }
        } else if (parent != null) {
            tag.setDoAfter(parent.getDoAfter());
            tag.setAfterReturnsAgain(parent.getAfterReturnsAgain());
        }
        Method doInitBody = this.getMethod(tagClass, "doInitBody", new Class[0]);
        if (doInitBody != null && doInitBody.getDeclaringClass().equals(tagClass)) {
            if (BodyTagSupport.class.equals(tagClass)) {
                tag.setDoInit(false);
            } else if (!BodyTag.class.isAssignableFrom(tagClass)) {
                tag.setDoInit(false);
            } else {
                tag.setDoInit(true);
            }
        } else if (parent != null) {
            tag.setDoInit(parent.getDoInit());
        }
        Method doCatch = this.getMethod(tagClass, "doCatch", new Class[]{Throwable.class});
        if (doCatch != null && doCatch.getDeclaringClass().equals(tagClass)) {
            if (!TryCatchFinally.class.isAssignableFrom(tagClass)) {
                tag.setDoCatch(false);
            } else {
                tag.setDoCatch(true);
            }
        } else if (parent != null) {
            tag.setDoCatch(parent.getDoCatch());
        }
        Method doFinally = this.getMethod(tagClass, "doFinally", new Class[0]);
        if (doFinally != null && doFinally.getDeclaringClass().equals(tagClass)) {
            if (!TryCatchFinally.class.isAssignableFrom(tagClass)) {
                tag.setDoFinally(false);
            } else {
                tag.setDoFinally(true);
            }
        } else if (parent != null) {
            tag.setDoFinally(parent.getDoFinally());
        }
        this.analyzeInject(tag, tagClass);
    }

    private void analyzeInject(AnalyzedTag tag, Class<?> cl) {
        if (cl == null) {
            return;
        }
        if (cl.isAnnotationPresent(EJB.class) || cl.isAnnotationPresent(EJBs.class)) {
            tag.setHasInjection(true);
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (method.getDeclaringClass() == Object.class) continue;
            if (method.getName().startsWith("set") && (method.isAnnotationPresent(Resource.class) || method.isAnnotationPresent(EJB.class) || method.isAnnotationPresent(Inject.class) || _persistenceContext != null && method.isAnnotationPresent(_persistenceContext) || _persistenceUnit != null && method.isAnnotationPresent(_persistenceUnit))) {
                tag.setHasInjection(true);
                continue;
            }
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            tag.setHasInjection(true);
        }
        for (AccessibleObject accessibleObject : cl.getDeclaredFields()) {
            if (!accessibleObject.isAnnotationPresent(Resource.class) && !accessibleObject.isAnnotationPresent(EJB.class) && !accessibleObject.isAnnotationPresent(Inject.class) && (_persistenceContext == null || !accessibleObject.isAnnotationPresent(_persistenceContext)) && (_persistenceUnit == null || !accessibleObject.isAnnotationPresent(_persistenceUnit))) continue;
            tag.setHasInjection(true);
        }
        this.analyzeInject(tag, cl.getSuperclass());
    }

    private Method getMethod(Class<?> tagClass, String name, Class<?>[] args) {
        try {
            return tagClass.getMethod(name, args);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private void analyze(AnalyzedTag tag, String name, String signature, Analyzer analyzer) {
        JavaClass javaClass = null;
        JavaMethod method = null;
        for (AnalyzedTag defTag = tag; defTag != null; defTag = defTag.getParent()) {
            method = defTag.getJavaClass().findMethod(name, signature);
            if (method == null) continue;
            javaClass = defTag.getJavaClass();
            break;
        }
        if (method == null) {
            return;
        }
        CodeAttribute codeAttribute = method.getCode();
        if (codeAttribute == null) {
            return;
        }
        CodeVisitor visitor = new CodeVisitor(javaClass, codeAttribute);
        try {
            visitor.analyze(analyzer);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        analyzer.complete(tag);
    }

    static IntMethodAnalyzer analyzeIntMethod(AnalyzedTag tag, String name, String signature) {
        if (!"()I".equals(signature)) {
            return null;
        }
        JavaMethod method = null;
        JavaClass javaClass = tag.getJavaClass();
        while (method == null && javaClass != null) {
            method = javaClass.findMethod(name, signature);
            if (method != null) continue;
            JClass parent = javaClass.getSuperClass();
            if (parent == null || !(parent instanceof JavaClass)) {
                return null;
            }
            javaClass = (JavaClass)parent;
        }
        if (method == null) {
            return null;
        }
        IntMethodAnalyzer analyzer = new IntMethodAnalyzer();
        CodeAttribute codeAttribute = method.getCode();
        if (codeAttribute == null) {
            return null;
        }
        CodeVisitor visitor = new CodeVisitor(javaClass, codeAttribute);
        try {
            visitor.analyze(analyzer);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        if (analyzer.isUnique()) {
            return analyzer;
        }
        return null;
    }

    static {
        Class<?> persistenceContext = null;
        Class<?> persistenceUnit = null;
        try {
            persistenceContext = Class.forName("javax.persistence.PersistenceContext");
            persistenceUnit = Class.forName("javax.persistence.PersistenceUnit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        _persistenceContext = persistenceContext;
        _persistenceUnit = persistenceUnit;
    }

    static class IntMethodAnalyzer
    extends Analyzer {
        private int _count = 0;
        private int _value = -1;
        private boolean _hasCode;
        private int _resultValue = -1;
        private int _resultValueCount = 0;

        IntMethodAnalyzer() {
        }

        public boolean isUnique() {
            return this._resultValueCount == 1;
        }

        public boolean hasCode() {
            return this._hasCode;
        }

        public int getValue() {
            return this._resultValue;
        }

        @Override
        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 172: {
                    if (count > 1) {
                        this._hasCode = true;
                    }
                    if (this._resultValueCount == 0) {
                        this._resultValue = this._value;
                        this._resultValueCount = 1;
                        break;
                    }
                    if (this._value == this._resultValue) break;
                    ++this._resultValueCount;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (count > 0) {
                        this._hasCode = true;
                    }
                    this._value = visitor.getOpcode() - 3;
                    break;
                }
                case 16: {
                    if (count > 0) {
                        this._hasCode = true;
                    }
                    this._value = visitor.getByteArg();
                    break;
                }
                case 17: {
                    if (count > 0) {
                        this._hasCode = true;
                    }
                    this._value = visitor.getShortArg();
                    break;
                }
                default: {
                    this._hasCode = true;
                    this._value = -1;
                }
            }
        }
    }

    static class FinallyAnalyzer
    extends Analyzer {
        private boolean _hasCode;
        private int _count = 0;

        FinallyAnalyzer() {
        }

        @Override
        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 177: {
                    if (count == 0) break;
                    this._hasCode = true;
                    break;
                }
                default: {
                    this._hasCode = true;
                }
            }
        }

        @Override
        public void complete(AnalyzedTag tag) {
            tag.setDoFinally(this._hasCode);
        }
    }

    static class CatchAnalyzer
    extends Analyzer {
        private boolean _hasCode;
        private int _count = 0;

        CatchAnalyzer() {
        }

        @Override
        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 177: {
                    if (count == 0) break;
                    this._hasCode = true;
                    break;
                }
                default: {
                    this._hasCode = true;
                }
            }
        }

        @Override
        public void complete(AnalyzedTag tag) {
            tag.setDoCatch(this._hasCode);
        }
    }

    static class InitAnalyzer
    extends Analyzer {
        private boolean _hasCode;
        private int _count = 0;

        InitAnalyzer() {
        }

        @Override
        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 177: {
                    if (count == 0) break;
                    this._hasCode = true;
                    break;
                }
                default: {
                    this._hasCode = true;
                }
            }
        }

        @Override
        public void complete(AnalyzedTag tag) {
            tag.setDoInit(this._hasCode);
        }
    }

    static class AfterAnalyzer
    extends AbstractTagMethodAnalyzer {
        private boolean _hasAgain;

        AfterAnalyzer(AnalyzedTag tag) {
            super(tag);
        }

        @Override
        protected void addReturnValue(int value) {
            if (value == 2) {
                this._hasAgain = true;
            } else if (value != 0 && value != 5) {
                this._hasAgain = true;
                this.setHasCode();
            }
        }

        @Override
        public void complete(AnalyzedTag tag) {
            tag.setDoAfter(this.hasCode());
            tag.setAfterReturnsAgain(this._hasAgain);
        }
    }

    static class EndAnalyzer
    extends AbstractTagMethodAnalyzer {
        private boolean _hasSkip;
        private boolean _hasEval;

        EndAnalyzer(AnalyzedTag tag) {
            super(tag);
        }

        @Override
        protected void addReturnValue(int value) {
            if (value == 5) {
                this._hasSkip = true;
            } else if (value == 6) {
                this._hasEval = true;
            } else {
                this._hasSkip = true;
                this._hasEval = true;
                this.setHasCode();
            }
        }

        @Override
        public void complete(AnalyzedTag tag) {
            tag.setDoEnd(this.hasCode());
            tag.setEndReturnsSkip(this._hasSkip);
            tag.setEndReturnsEval(this._hasEval);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[end:" + this.hasCode() + ",skip:" + this._hasSkip + ",eval:" + this._hasEval + "]";
        }
    }

    static class StartAnalyzer
    extends AbstractTagMethodAnalyzer {
        private boolean _hasSkip;
        private boolean _hasInclude;
        private boolean _hasBuffered;

        StartAnalyzer(AnalyzedTag tag) {
            super(tag);
        }

        @Override
        protected void addReturnValue(int value) {
            if (value == 0) {
                this._hasSkip = true;
            } else if (value == 1) {
                this._hasInclude = true;
            } else if (value == 2) {
                this._hasBuffered = true;
            } else {
                this._hasSkip = true;
                this._hasInclude = true;
                this._hasBuffered = true;
                this.setHasCode();
            }
        }

        @Override
        public void complete(AnalyzedTag tag) {
            tag.setDoStart(this.hasCode());
            tag.setStartReturnsSkip(this._hasSkip);
            tag.setStartReturnsInclude(this._hasInclude);
            tag.setStartReturnsBuffered(this._hasBuffered);
        }
    }

    static class AbstractTagMethodAnalyzer
    extends Analyzer {
        private AnalyzedTag _tag;
        private boolean _hasCode;
        private int _count = 0;
        private int _value = -1;

        protected AbstractTagMethodAnalyzer(AnalyzedTag tag) {
            this._tag = tag;
        }

        protected boolean hasCode() {
            return this._hasCode;
        }

        protected void setHasCode() {
            this._hasCode = true;
        }

        @Override
        public void analyze(CodeVisitor visitor) {
            int count = this._count++;
            switch (visitor.getOpcode()) {
                case 172: {
                    if (count != 1) {
                        this._hasCode = true;
                    }
                    this.addReturnValue(this._value);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (count != 0) {
                        this._hasCode = true;
                    }
                    this._value = visitor.getOpcode() - 3;
                    break;
                }
                case 16: {
                    if (count != 0) {
                        this._hasCode = true;
                    }
                    this._value = visitor.getByteArg();
                    break;
                }
                case 17: {
                    if (count != 0) {
                        this._hasCode = true;
                    }
                    this._value = visitor.getShortArg();
                    break;
                }
                case 42: {
                    if (count == 0) break;
                    this._hasCode = true;
                    break;
                }
                case 182: 
                case 183: {
                    if (count != 1) {
                        this._hasCode = true;
                    }
                    this._value = -1;
                    int index = visitor.getShortArg();
                    JavaClass jClass = visitor.getJavaClass();
                    MethodRefConstant methodRef = jClass.getConstantPool().getMethodRef(index);
                    IntMethodAnalyzer value = TagAnalyzer.analyzeIntMethod(this._tag, methodRef.getName(), methodRef.getType());
                    if (value != null) {
                        this._value = value.getValue();
                        if (count == 1) {
                            this._count = 1;
                        }
                        if (!value.hasCode()) break;
                        this._hasCode = true;
                        break;
                    }
                    this._hasCode = true;
                    break;
                }
                default: {
                    this._hasCode = true;
                    this._value = -1;
                }
            }
        }

        protected void addReturnValue(int value) {
        }
    }

    static class Analyzer
    extends com.caucho.bytecode.Analyzer {
        Analyzer() {
        }

        @Override
        public void analyze(CodeVisitor visitor) {
        }

        public void complete(AnalyzedTag tag) {
        }
    }
}

