/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.util.L10N;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.el.ELContext;
import javax.el.ELException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ParseDateTag
extends BodyTagSupport {
    private static L10N L = new L10N(ParseDateTag.class);
    private Expr _valueExpr;
    private Expr _typeExpr;
    private Expr _dateStyleExpr;
    private Expr _timeStyleExpr;
    private Expr _parseLocaleExpr;
    private Expr _patternExpr;
    private Expr _timeZoneExpr;
    private String _var;
    private String _scope;

    public void setValue(Expr value) {
        this._valueExpr = value;
    }

    public void setType(Expr type) {
        this._typeExpr = type;
    }

    public void setDateStyle(Expr style) {
        this._dateStyleExpr = style;
    }

    public void setTimeStyle(Expr style) {
        this._timeStyleExpr = style;
    }

    public void setPattern(Expr pattern) {
        this._patternExpr = pattern;
    }

    public void setTimeZone(Expr zone) {
        this._timeZoneExpr = zone;
    }

    public void setParseLocale(Expr locale) {
        this._parseLocaleExpr = locale;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public int doEndTag() throws JspException {
        try {
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            JspWriter out = pageContext.getOut();
            String string = this._valueExpr != null ? this._valueExpr.evalString(pageContext.getELContext()) : this.bodyContent.getString().trim();
            DateFormat format = this.getFormat();
            Date value = format.parse(string);
            if (this._var == null) {
                out.print((Object)value);
            } else {
                CoreSetTag.setValue(pageContext, this._var, this._scope, value);
            }
        }
        catch (IOException pageContext) {
        }
        catch (ParseException e) {
            throw new JspException((Throwable)e);
        }
        catch (ELException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DateFormat getFormat() throws JspException, ELException {
        TimeZone timeZone;
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        ELContext env = pageContext.getELContext();
        DateFormat format = null;
        Locale locale = null;
        if (this._parseLocaleExpr != null) {
            Object localeObj = this._parseLocaleExpr.evalObject(env);
            if (localeObj instanceof Locale) {
                locale = (Locale)localeObj;
            } else if (localeObj instanceof String) {
                locale = PageContextImpl.getLocale((String)localeObj, null);
            }
        }
        if (locale == null) {
            locale = pageContext.getLocale();
        }
        String type = null;
        if (this._typeExpr != null) {
            type = this._typeExpr.evalString(env);
        }
        int dateStyle = 2;
        if (this._dateStyleExpr != null) {
            dateStyle = ParseDateTag.getDateStyle(this._dateStyleExpr.evalString(env));
        }
        int timeStyle = 2;
        if (this._timeStyleExpr != null) {
            timeStyle = ParseDateTag.getDateStyle(this._timeStyleExpr.evalString(env));
        }
        if (locale != null) {
            if (type == null || type.equals("date")) {
                format = DateFormat.getDateInstance(dateStyle, locale);
            } else if (type.equals("both")) {
                format = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
            } else {
                if (!type.equals("time")) throw new JspException(L.l("illegal type `{0}'", (Object)type));
                format = DateFormat.getTimeInstance(timeStyle, locale);
            }
        } else if (type == null || type.equals("date")) {
            format = DateFormat.getDateInstance(dateStyle);
        } else if (type.equals("both")) {
            format = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        } else {
            if (!type.equals("time")) throw new JspException(L.l("illegal type `{0}'", (Object)type));
            format = DateFormat.getTimeInstance(timeStyle);
        }
        if (format == null) {
            return null;
        }
        if (this._patternExpr != null) {
            String pattern = this._patternExpr.evalString(env);
            try {
                ((SimpleDateFormat)format).applyPattern(pattern);
            }
            catch (ClassCastException e) {
                format = new SimpleDateFormat(pattern, locale);
            }
        }
        if ((timeZone = this.getTimeZone()) == null) return format;
        format.setTimeZone(timeZone);
        return format;
    }

    private TimeZone getTimeZone() throws ELException {
        PageContextImpl pageContext;
        Object timeZoneObj;
        TimeZone zone;
        if (this._timeZoneExpr != null && (zone = this.getTimeZone(timeZoneObj = this._timeZoneExpr.evalObject((pageContext = (PageContextImpl)this.pageContext).getELContext()))) != null) {
            return zone;
        }
        Object timeZoneObj2 = this.pageContext.getAttribute("com.caucho.time-zone");
        if (timeZoneObj2 != null) {
            return (TimeZone)timeZoneObj2;
        }
        timeZoneObj2 = Config.find((PageContext)this.pageContext, (String)"javax.servlet.jsp.jstl.fmt.timeZone");
        return this.getTimeZone(timeZoneObj2);
    }

    private TimeZone getTimeZone(Object timeZoneObj) {
        if (timeZoneObj instanceof TimeZone) {
            return (TimeZone)timeZoneObj;
        }
        if (timeZoneObj instanceof String) {
            String timeZoneString = (String)timeZoneObj;
            return TimeZone.getTimeZone(timeZoneString);
        }
        return null;
    }

    public static int getDateStyle(String style) throws JspException {
        if (style == null || style.equals("default")) {
            return 2;
        }
        if (style.equals("short")) {
            return 3;
        }
        if (style.equals("medium")) {
            return 2;
        }
        if (style.equals("long")) {
            return 1;
        }
        if (style.equals("full")) {
            return 0;
        }
        throw new JspException(L.l("illegal date style `{0}'", (Object)style));
    }
}

