/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.util.L10N;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.el.ELContext;
import javax.el.ELException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ParseNumberTag
extends BodyTagSupport {
    private static L10N L = new L10N(ParseNumberTag.class);
    private Expr _valueExpr;
    private Expr _typeExpr;
    private Expr _patternExpr;
    private Expr _parseLocaleExpr;
    private Expr _integerOnlyExpr;
    private String _var;
    private String _scope;

    public void setValue(Expr value) {
        this._valueExpr = value;
    }

    public void setType(Expr type) {
        this._typeExpr = type;
    }

    public void setPattern(Expr pattern) {
        this._patternExpr = pattern;
    }

    public void setParseLocale(Expr locale) {
        this._parseLocaleExpr = locale;
    }

    public void setIntegerOnly(Expr integerOnly) {
        this._integerOnlyExpr = integerOnly;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public int doEndTag() throws JspException {
        try {
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            JspWriter out = pageContext.getOut();
            NumberFormat format = this.getFormat();
            String string = this._valueExpr != null ? this._valueExpr.evalString(pageContext.getELContext()) : this.bodyContent.getString().trim();
            Number value = format.parse(string);
            if (this._var == null) {
                out.print((Object)value);
            } else {
                CoreSetTag.setValue(pageContext, this._var, this._scope, value);
            }
        }
        catch (IOException pageContext) {
        }
        catch (ParseException e) {
            throw new JspException((Throwable)e);
        }
        catch (ELException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    protected NumberFormat getFormat() throws JspException, ELException {
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        ELContext env = pageContext.getELContext();
        NumberFormat format = null;
        Locale locale = null;
        if (this._parseLocaleExpr != null) {
            Object localeObj = this._parseLocaleExpr.evalObject(env);
            if (localeObj instanceof Locale) {
                locale = (Locale)localeObj;
            } else if (localeObj instanceof String) {
                locale = PageContextImpl.getLocale((String)localeObj, null);
            }
        }
        if (locale == null) {
            locale = pageContext.getLocale();
        }
        String type = null;
        if (this._typeExpr != null) {
            type = this._typeExpr.evalString(env);
        }
        if (type == null || type.equals("") || type.equals("number")) {
            format = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
            DecimalFormat decimalFormat = (DecimalFormat)format;
            if (this._patternExpr != null) {
                decimalFormat.applyPattern(this._patternExpr.evalString(env));
            }
        } else if (type.equals("percent")) {
            format = locale != null ? NumberFormat.getPercentInstance(locale) : NumberFormat.getPercentInstance();
        } else if (type.equals("currency")) {
            format = locale != null ? NumberFormat.getCurrencyInstance(locale) : NumberFormat.getCurrencyInstance(locale);
        } else {
            throw new JspException(L.l("unknown formatNumber type `{0}'", (Object)type));
        }
        if (this._integerOnlyExpr != null) {
            format.setParseIntegerOnly(this._integerOnlyExpr.evalBoolean(env));
        }
        return format;
    }
}

