/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jsp.BodyContentImpl;
import com.caucho.jsp.ResinJspWriter;
import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class CoreImportTag
extends BodyTagSupport
implements NameValueTag {
    private static L10N L = new L10N(CoreImportTag.class);
    private String _url;
    private String _context;
    private CharBuffer _query = new CharBuffer();
    private String _charEncoding;
    private String _var;
    private String _scope;
    private String _varReader;
    private Reader _reader;
    private Reader _oldReader;

    public void setURL(String url) {
        this._url = url;
    }

    public void setContext(String context) {
        this._context = context;
    }

    @Override
    public void addParam(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if (this._query.length() != 0) {
            this._query.append('&');
        }
        this._query.append(name);
        this._query.append('=');
        int len = value.length();
        block6: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '&': {
                    this._query.append("%26");
                    continue block6;
                }
                case '%': {
                    this._query.append("%25");
                    continue block6;
                }
                case '+': {
                    this._query.append("%2b");
                    continue block6;
                }
                case '=': {
                    this._query.append("%3d");
                    continue block6;
                }
                default: {
                    this._query.append(ch);
                }
            }
        }
    }

    public void setCharEncoding(String charEncoding) {
        this._charEncoding = charEncoding;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setVarReader(String varReader) {
        this._varReader = varReader;
    }

    public int doStartTag() throws JspException {
        this._query.clear();
        BodyContent jspWriter = null;
        try {
            if (this._varReader != null) {
                jspWriter = this.pageContext.pushBody();
                BodyContentImpl body = (BodyContentImpl)this.pageContext.getOut();
                this.handleBody(body);
                this._reader = body.getReader();
                this.pageContext.setAttribute(this._varReader, (Object)this._reader);
                int n = 1;
                return n;
            }
            int body = 2;
            return body;
        }
        catch (JspException e) {
            throw e;
        }
        catch (ServletException e) {
            throw new JspException((Throwable)e);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (jspWriter != null) {
                this.pageContext.popBody();
            }
        }
    }

    public int doEndTag() throws JspException {
        if (this._varReader != null) {
            this.pageContext.removeAttribute(this._varReader);
        } else {
            try {
                BodyContent jspWriter = this.pageContext.pushBody();
                BodyContentImpl body = (BodyContentImpl)this.pageContext.getOut();
                this.handleBody(body);
                if (this._var != null) {
                    String value = body.getString();
                    this.pageContext.popBody();
                    CoreSetTag.setValue(this.pageContext, this._var, this._scope, value);
                } else {
                    body.writeOut((Writer)body.getEnclosingWriter());
                    this.pageContext.popBody();
                }
            }
            catch (JspException e) {
                throw e;
            }
            catch (ServletException e) {
                Throwable e1 = e;
                if (e1.getCause() != null) {
                    e1 = e1.getCause();
                }
                throw new JspException(e1.getMessage(), e1);
            }
            catch (Exception e) {
                throw new JspException(e.getMessage(), (Throwable)e);
            }
        }
        return 6;
    }

    private String getCharEncoding() {
        if (this._charEncoding != null && !"".equals(this._charEncoding)) {
            return this._charEncoding;
        }
        String charEncoding = this._charEncoding;
        if (this._charEncoding == null || "".equals(this._charEncoding)) {
            charEncoding = null;
        }
        if (charEncoding == null) {
            WebApp webApp = WebApp.getCurrent();
            if (webApp.getJsp() != null) {
                charEncoding = webApp.getJsp().getPageEncoding();
            }
            if (charEncoding == null) {
                charEncoding = webApp.getCharacterEncoding();
            }
        }
        return charEncoding;
    }

    private void handleBody(BodyContentImpl body) throws JspException, ServletException, IOException {
        BodyContentImpl out;
        String url = this._url;
        if (url == null || url.equals("")) {
            throw new JspTagException(L.l("URL may not be null for `{0}'", (Object)this._url));
        }
        if (this._query != null && this._query.getLength() != 0) {
            int p = url.indexOf(63);
            url = p > 0 ? url.substring(0, p) + '?' + this._query + '&' + url.substring(p + 1) : url + '?' + this._query;
        }
        if ((out = body) instanceof ResinJspWriter) {
            ((ResinJspWriter)((Object)out)).flushBuffer();
        }
        if (this._context != null) {
            String context = this._context;
            if (!url.startsWith("/")) {
                throw new JspException(L.l("URL `{0}' must start with `/' with context `{0}'", (Object)url, (Object)context));
            }
            if (context != null && context.startsWith("/")) {
                int status;
                ServletContext app = this.pageContext.getServletContext().getContext(context);
                RequestDispatcher disp = app.getRequestDispatcher(url);
                if (disp == null) {
                    throw new JspException(L.l("URL `{0}' does not map to any servlet", (Object)url));
                }
                CauchoResponse response = (CauchoResponse)this.pageContext.getResponse();
                String charEncoding = this.getCharEncoding();
                if (charEncoding != null) {
                    response.getResponseStream().setEncoding(charEncoding);
                }
                ServletRequest request = this.pageContext.getRequest();
                disp.include(request, (ServletResponse)response);
                Integer statusCode = (Integer)request.getAttribute("com.caucho.dispatch.response.statusCode");
                if (statusCode != null && ((status = statusCode.intValue()) < 200 || status > 299)) {
                    String message = L.l("c:import status code {0} received while serving {1}", (Object)statusCode, (Object)(context + url));
                    throw new JspException(message);
                }
            } else {
                this.handleExternalBody(context + url);
            }
            return;
        }
        int colon = url.indexOf(58);
        int slash = url.indexOf(47);
        if (slash == 0 || colon < 0 || slash < 0 || slash < colon) {
            ServletRequest request = this.pageContext.getRequest();
            CauchoResponse response = (CauchoResponse)this.pageContext.getResponse();
            String charEncoding = this.getCharEncoding();
            if (charEncoding != null) {
                response.getResponseStream().setEncoding(charEncoding);
            }
            RequestDispatcher disp = request.getRequestDispatcher(url);
            JstlImportResponseWrapper wrapper = new JstlImportResponseWrapper(response);
            disp.include(request, (ServletResponse)wrapper);
            int status = wrapper.getStatus();
            if (status < 200 || status > 299) {
                String message = L.l("c:import status code {0} recieved while serving {1}", (Object)status, (Object)url);
                throw new JspException(message);
            }
        } else {
            this.handleExternalBody(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExternalBody(String url) throws JspException, ServletException, IOException {
        URL netURL = new URL(url);
        URLConnection conn = netURL.openConnection();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection cfr_ignored_0 = (HttpURLConnection)conn;
            HttpURLConnection.setFollowRedirects(true);
        }
        InputStream is = conn.getInputStream();
        try {
            int ch;
            int p;
            ReadStream in = Vfs.openRead(is);
            String encoding = conn.getContentEncoding();
            String contentType = conn.getContentType();
            if (this._charEncoding != null) {
                encoding = this._charEncoding;
                if (encoding != null && !encoding.equals("")) {
                    in.setEncoding(encoding);
                }
            } else if (encoding != null) {
                in.setEncoding(encoding);
            } else if (contentType != null && (p = contentType.indexOf("charset=")) > 0) {
                CharBuffer cb = new CharBuffer();
                for (int i = p + 8; i < contentType.length(); ++i) {
                    char ch2 = contentType.charAt(i);
                    if (ch2 == '\"' || ch2 == '\'') continue;
                    if (ch2 >= 'a' && ch2 <= 'z') {
                        cb.append(ch2);
                        continue;
                    }
                    if (ch2 >= 'A' && ch2 <= 'Z') {
                        cb.append(ch2);
                        continue;
                    }
                    if (ch2 >= '0' && ch2 <= '9') {
                        cb.append(ch2);
                        continue;
                    }
                    if (ch2 != '-' && ch2 != '_') break;
                    cb.append(ch2);
                }
                encoding = cb.toString();
                in.setEncoding(encoding);
            }
            JspWriter out = this.pageContext.getOut();
            while ((ch = in.readChar()) >= 0) {
                out.print((char)ch);
            }
        }
        finally {
            is.close();
        }
    }

    static class JstlImportResponseWrapper
    extends HttpServletResponseWrapper {
        private int _status = 200;

        JstlImportResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int sc) {
            this._status = sc;
        }

        public int getStatus() {
            return this._status;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.getResponse() + "]";
        }
    }
}

