/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.types.Period;
import com.caucho.loader.DynamicClassLoader;
import javax.annotation.PostConstruct;

public class DependencyCheckInterval {
    private long _interval = 2000L;

    public void setValue(Period period) {
        this._interval = period.getPeriod();
    }

    @PostConstruct
    public void init() {
        ClassLoader loader;
        for (loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof DynamicClassLoader)) continue;
            DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
            dynLoader.setDependencyCheckInterval(this._interval);
            return;
        }
        if (loader == null) {
            DynamicClassLoader.setGlobalDependencyCheckInterval(this._interval);
        }
    }

    public String toString() {
        return "DependencyCheckInterval[]";
    }
}

