/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.AddLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentAdmin;
import com.caucho.loader.EnvironmentApply;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentEnhancerListener;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.WeakStopListener;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.loader.enhancer.ScanManager;
import com.caucho.loader.module.ArtifactManager;
import com.caucho.management.server.EnvironmentMXBean;
import com.caucho.util.Crc64;
import com.caucho.util.CurrentTime;
import com.caucho.util.LruCache;
import com.caucho.util.ResinThreadPoolExecutor;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnvironmentClassLoader
extends DynamicClassLoader {
    private static Logger _log;
    private static final Object _childListenerLock;
    private static EnvironmentLocal<ArrayList<EnvironmentListener>> _childListeners;
    private static EnvironmentLocal<ArrayList<AddLoaderListener>> _addLoaderListeners;
    private EnvironmentBean _owner;
    private Map<String, Object> _attributes = new ConcurrentHashMap<String, Object>(8);
    private ArrayList<ScanListener> _scanListeners;
    private ArrayList<ScanRoot> _pendingScanRoots = new ArrayList();
    private AtomicReference<ArtifactManager> _artifactManagerRef = new AtomicReference();
    private ArtifactManager _artifactManager;
    private ArrayList<String> _packageList = new ArrayList();
    private ArrayList<EnvironmentListener> _listeners = new ArrayList();
    private Map<String, String> _resourceAliasMap;
    private LruCache<String, ResourceEntry> _resourceCacheMap = new LruCache(256);
    private WeakStopListener _stopListener;
    private volatile Lifecycle _lifecycle = new Lifecycle();
    private boolean _isConfigComplete;
    private EnvironmentAdmin _admin;
    private Throwable _configException;

    protected EnvironmentClassLoader(ClassLoader parent, String id) {
        this(parent, id, false);
    }

    protected EnvironmentClassLoader(ClassLoader parent, String id, boolean isRoot) {
        super(parent, true, isRoot);
        if (id != null) {
            this.setId(id);
        }
        this.initListeners();
    }

    public static EnvironmentClassLoader create() {
        ClassLoader parent = null;
        String id = null;
        return EnvironmentClassLoader.create(parent, id);
    }

    public static EnvironmentClassLoader create(String id) {
        ClassLoader parent = null;
        return EnvironmentClassLoader.create(parent, id);
    }

    public static EnvironmentClassLoader create(ClassLoader parent) {
        String id = null;
        return EnvironmentClassLoader.create(parent, id);
    }

    public static EnvironmentClassLoader create(ClassLoader parent, String id) {
        String className;
        if (parent == null) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        ClassLoader systemClassLoader = EnvironmentClassLoader.getSystemClassLoaderSafe();
        if (parent == null || EnvironmentClassLoader.isParent(parent, systemClassLoader)) {
            parent = systemClassLoader;
        }
        if ((className = System.getProperty("caucho.environment.class.loader")) != null) {
            try {
                Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(className);
                Constructor<?> ctor = cl.getConstructor(ClassLoader.class, String.class);
                Object instance = ctor.newInstance(parent, id);
                return (EnvironmentClassLoader)instance;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new EnvironmentClassLoader(parent, id);
    }

    private static boolean isParent(ClassLoader parent, ClassLoader child) {
        if (parent == null) {
            return true;
        }
        if (child == null) {
            return false;
        }
        if (parent.equals(child)) {
            return true;
        }
        return EnvironmentClassLoader.isParent(parent, child.getParent());
    }

    public EnvironmentBean getOwner() {
        return this._owner;
    }

    public void setOwner(EnvironmentBean owner) {
        this._owner = owner;
    }

    public void setConfigException(Throwable e) {
        if (this._configException == null) {
            this._configException = e;
        }
    }

    public Throwable getConfigException() {
        return this._configException;
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    public EnvironmentMXBean getAdmin() {
        return this._admin;
    }

    @Override
    public void init() {
        super.init();
        this.initEnvironment();
    }

    protected void initEnvironment() {
    }

    public Object getAttribute(String name) {
        if (this._attributes != null) {
            return this._attributes.get(name);
        }
        return null;
    }

    public Object setAttribute(String name, Object obj) {
        if (obj == null) {
            if (this._attributes == null) {
                return null;
            }
            return this._attributes.remove(name);
        }
        if (this._attributes == null) {
            this._attributes = new ConcurrentHashMap<String, Object>(8);
        }
        return this._attributes.put(name, obj);
    }

    public Object putIfAbsent(String name, Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (this._attributes == null) {
            this._attributes = new ConcurrentHashMap<String, Object>(8);
        }
        return this._attributes.putIfAbsent(name, obj);
    }

    public Object removeAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.remove(name);
    }

    @Override
    public URL getResource(String name) {
        ResourceEntry entry = this._resourceCacheMap.get(name);
        if (entry == null || entry.isModified()) {
            URL resource = super.getResource(name);
            entry = new ResourceEntry(resource);
            this._resourceCacheMap.put(name, entry);
        }
        return entry.getResource();
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        ResourceEntry entry = this._resourceCacheMap.get(name);
        if (entry == null || entry.isModified()) {
            URL resource = super.getResource(name);
            entry = new ResourceEntry(resource);
            this._resourceCacheMap.put(name, entry);
        }
        return entry.getResourceAsStream();
    }

    public void putResourceAlias(String name, String actualName) {
        if (this._resourceAliasMap == null) {
            this._resourceAliasMap = new ConcurrentHashMap<String, String>();
        }
        this._resourceAliasMap.put(name, actualName);
    }

    @Override
    public String getResourceAlias(String name) {
        String actualName;
        if (this._resourceAliasMap != null && (actualName = this._resourceAliasMap.get(name)) != null) {
            return actualName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EnvironmentListener listener) {
        ArrayList<EnvironmentListener> arrayList = this._listeners;
        synchronized (arrayList) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                EnvironmentListener oldListener = this._listeners.get(i);
                if (listener == oldListener) {
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
            this._listeners.add(listener);
        }
        if (this._lifecycle.isStarting()) {
            listener.environmentBind(this);
        }
        if (this._lifecycle.isStarting() && this._isConfigComplete) {
            listener.environmentStart(this);
        }
    }

    private void initListeners() {
        for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof EnvironmentClassLoader)) continue;
            EnvironmentClassLoader loader = (EnvironmentClassLoader)parent;
            if (this._stopListener == null) {
                this._stopListener = new WeakStopListener(this);
            }
            loader.addListener(this._stopListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(EnvironmentListener listener) {
        ArrayList<EnvironmentListener> listeners = this._listeners;
        if (this._listeners == null) {
            return;
        }
        ArrayList<EnvironmentListener> arrayList = listeners;
        synchronized (arrayList) {
            for (int i = listeners.size() - 1; i >= 0; --i) {
                EnvironmentListener oldListener = listeners.get(i);
                if (listener == oldListener) {
                    listeners.remove(i);
                    return;
                }
                if (oldListener != null) continue;
                listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildListener(EnvironmentListener listener) {
        Object object = _childListenerLock;
        synchronized (object) {
            ArrayList<EnvironmentListener> listeners;
            if (_childListeners == null) {
                _childListeners = new EnvironmentLocal();
            }
            if ((listeners = _childListeners.getLevel(this)) == null) {
                listeners = new ArrayList();
                _childListeners.set(listeners, this);
            }
            listeners.add(listener);
        }
        if (this._lifecycle.isStarting() && this._isConfigComplete) {
            listener.environmentStart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChildListener(EnvironmentListener listener) {
        Object object = _childListenerLock;
        synchronized (object) {
            if (_childListeners == null) {
                return;
            }
            ArrayList<EnvironmentListener> listeners = _childListeners.getLevel(this);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<EnvironmentListener> getEnvironmentListeners() {
        ArrayList<EnvironmentListener> listeners = new ArrayList<EnvironmentListener>();
        if (_childListeners != null) {
            Object object = _childListenerLock;
            synchronized (object) {
                for (ClassLoader loader = this; loader != null; loader = loader.getParent()) {
                    ArrayList<EnvironmentListener> childListeners;
                    if (!(loader instanceof EnvironmentClassLoader) || (childListeners = _childListeners.getLevel(loader)) == null) continue;
                    listeners.addAll(childListeners);
                }
            }
        }
        if (this._listeners == null) {
            return listeners;
        }
        ArrayList<EnvironmentListener> envListeners = this._listeners;
        if (envListeners != null) {
            ArrayList<EnvironmentListener> arrayList = envListeners;
            synchronized (arrayList) {
                for (int i = 0; i < envListeners.size(); ++i) {
                    EnvironmentListener listener = envListeners.get(i);
                    if (listener != null) {
                        listeners.add(listener);
                        continue;
                    }
                    envListeners.remove(i);
                    --i;
                }
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoaderListener(AddLoaderListener listener) {
        Object object = _childListenerLock;
        synchronized (object) {
            ArrayList<AddLoaderListener> listeners;
            if (_addLoaderListeners == null) {
                _addLoaderListeners = new EnvironmentLocal();
            }
            if ((listeners = _addLoaderListeners.getLevel(this)) == null) {
                listeners = new ArrayList();
                _addLoaderListeners.set(listeners, this);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
        listener.addLoader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<AddLoaderListener> getLoaderListeners() {
        ArrayList<AddLoaderListener> listeners = new ArrayList<AddLoaderListener>();
        if (_addLoaderListeners == null) {
            return listeners;
        }
        Object object = _childListenerLock;
        synchronized (object) {
            for (ClassLoader loader = this; loader != null; loader = loader.getParent()) {
                ArrayList<AddLoaderListener> childListeners;
                if (!(loader instanceof EnvironmentClassLoader) || (childListeners = _addLoaderListeners.getLevel(loader)) == null) continue;
                listeners.addAll(childListeners);
            }
        }
        return listeners;
    }

    @Override
    protected void configureEnhancerEvent() {
        ArrayList<AddLoaderListener> listeners = this.getLoaderListeners();
        for (int i = 0; listeners != null && i < listeners.size(); ++i) {
            AddLoaderListener listener = listeners.get(i);
            if (!listener.isEnhancer()) continue;
            listeners.get(i).addLoader(this);
        }
    }

    @Override
    protected void configurePostEnhancerEvent() {
        ArrayList<AddLoaderListener> listeners = this.getLoaderListeners();
        for (int i = 0; listeners != null && i < listeners.size(); ++i) {
            AddLoaderListener listener = listeners.get(i);
            if (listener.isEnhancer()) continue;
            listeners.get(i).addLoader(this);
        }
    }

    @Override
    public void addURL(URL url) {
        if (this.containsURL(url)) {
            return;
        }
        super.addURL(url);
        this._pendingScanRoots.add(new ScanRoot(url, null));
    }

    public void addScanPackage(URL url, String rootPackage) {
        if (!this.containsURL(url)) {
            super.addURL(url);
        }
        this._packageList.add(rootPackage);
        this._pendingScanRoots.add(new ScanRoot(url, rootPackage));
        this.sendAddLoaderEvent();
    }

    @Override
    public String getHash() {
        String superHash = super.getHash();
        long crc = Crc64.generate(superHash);
        for (String pkg : this._packageList) {
            crc = Crc64.generate(crc, pkg);
        }
        return Long.toHexString(crc);
    }

    @Override
    public void addScanRoot() {
        super.addScanRoot();
        this.addScanRoot(this.getParent());
    }

    private void addScanRoot(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        this.addScanRoot(loader.getParent());
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlParent = (URLClassLoader)loader;
            for (URL url : urlParent.getURLs()) {
                this._pendingScanRoots.add(new ScanRoot(url, null));
            }
        }
    }

    public void addScanListener(ScanListener listener) {
        int i;
        if (this._scanListeners == null) {
            this._scanListeners = new ArrayList();
        }
        for (i = 0; i < this._scanListeners.size() && listener.getScanPriority() >= this._scanListeners.get(i).getScanPriority(); ++i) {
        }
        this._scanListeners.add(i, listener);
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (URL url : this.getURLs()) {
            if (!this.isScanRootAvailable(url)) continue;
            urlList.add(url);
        }
        if (urlList.size() > 0) {
            block7: {
                try {
                    this.make();
                }
                catch (Exception e) {
                    EnvironmentClassLoader.log().log(Level.WARNING, e.toString(), e);
                    if (this._configException != null) break block7;
                    this._configException = e;
                }
            }
            ArrayList<ScanListener> selfList = new ArrayList<ScanListener>();
            selfList.add(listener);
            ScanManager scanManager = new ScanManager(selfList);
            for (URL url : urlList) {
                scanManager.scan(this, url, null);
            }
        }
    }

    private boolean isScanRootAvailable(URL url) {
        for (ScanRoot scanRoot : this._pendingScanRoots) {
            if (!url.equals(scanRoot.getUrl())) continue;
            return false;
        }
        return true;
    }

    public ArtifactManager createArtifactManager() {
        if (this._artifactManager == null) {
            ArtifactManager manager = new ArtifactManager(this);
            this._artifactManagerRef.compareAndSet(null, manager);
            this._artifactManager = this._artifactManagerRef.get();
        }
        return this._artifactManager;
    }

    public ArtifactManager getArtifactManager() {
        return this._artifactManager;
    }

    @Override
    protected Class<?> findImportClass(String name) {
        if (this._artifactManager != null) {
            return this._artifactManager.findImportClass(name);
        }
        return null;
    }

    @Override
    protected URL getImportResource(String name) {
        if (this._artifactManager != null) {
            return this._artifactManager.getImportResource(name);
        }
        return null;
    }

    @Override
    protected void buildImportClassPath(ArrayList<String> cp) {
        if (this._artifactManager != null) {
            this._artifactManager.buildImportClassPath(cp);
        }
    }

    public void applyVisibleModules(EnvironmentApply apply) {
        apply.apply(this);
        for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof EnvironmentClassLoader)) continue;
            EnvironmentClassLoader env = (EnvironmentClassLoader)parent;
            env.applyVisibleModules(apply);
            break;
        }
        if (this._artifactManager != null) {
            this._artifactManager.applyVisibleModules(apply);
        }
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public void scan() {
        block6: {
            this.configureEnhancerEvent();
            ArrayList<ScanRoot> rootList = new ArrayList<ScanRoot>(this._pendingScanRoots);
            this._pendingScanRoots.clear();
            try {
                int rootListSize;
                block7: {
                    rootListSize = rootList.size();
                    if (this._scanListeners == null || rootListSize <= 0) break block6;
                    try {
                        this.make();
                    }
                    catch (Exception e) {
                        EnvironmentClassLoader.log().log(Level.WARNING, e.toString(), e);
                        if (this._configException != null) break block7;
                        this._configException = e;
                    }
                }
                ScanManager scanManager = new ScanManager(this._scanListeners);
                for (int i = 0; i < rootListSize; ++i) {
                    ScanRoot root = rootList.get(i);
                    scanManager.scan(this, root.getUrl(), root.getPackageName());
                }
            }
            catch (Exception e) {
                if (this._configException == null) {
                    this._configException = e;
                }
                throw ConfigException.create(e);
            }
        }
    }

    private void config() {
        EnvironmentListener listener;
        int i;
        this.sendAddLoaderEvent();
        ArrayList<EnvironmentListener> listeners = this.getEnvironmentListeners();
        int size = listeners.size();
        for (i = 0; listeners != null && i < size; ++i) {
            listener = listeners.get(i);
            if (!(listener instanceof EnvironmentEnhancerListener)) continue;
            EnvironmentEnhancerListener enhancerListener = (EnvironmentEnhancerListener)listener;
            enhancerListener.environmentConfigureEnhancer(this);
        }
        for (i = 0; listeners != null && i < size; ++i) {
            listener = listeners.get(i);
            listener.environmentConfigure(this);
        }
    }

    private void bind() {
        this.config();
        ArrayList<EnvironmentListener> listeners = this.getEnvironmentListeners();
        int size = listeners.size();
        for (int i = 0; listeners != null && i < size; ++i) {
            EnvironmentListener listener = listeners.get(i);
            listener.environmentBind(this);
        }
        this._isConfigComplete = true;
    }

    public void start() {
        if (!this._lifecycle.toStarting()) {
            this.startListeners();
            return;
        }
        this.sendAddLoaderEvent();
        this.bind();
        if (this._artifactManager != null) {
            this._artifactManager.start();
        }
        this.startListeners();
        this._admin = new EnvironmentAdmin(this);
        this._admin.register();
        this._lifecycle.toActive();
    }

    private void startListeners() {
        ArrayList<EnvironmentListener> listeners = this.getEnvironmentListeners();
        int size = listeners.size();
        for (int i = 0; listeners != null && i < size; ++i) {
            EnvironmentListener listener = listeners.get(i);
            listener.environmentStart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        ArrayList<EnvironmentListener> listeners = this.getEnvironmentListeners();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this);
        try {
            if (listeners != null) {
                for (int i = listeners.size() - 1; i >= 0; --i) {
                    EnvironmentListener listener = listeners.get(i);
                    try {
                        listener.environmentStop(this);
                        continue;
                    }
                    catch (Throwable e) {
                        EnvironmentClassLoader.log().log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            super.stop();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            ResinThreadPoolExecutor.getThreadPool().stopEnvironment(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            WeakStopListener stopListener = this._stopListener;
            this._stopListener = null;
            super.destroy();
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof EnvironmentClassLoader)) continue;
                EnvironmentClassLoader loader = (EnvironmentClassLoader)parent;
                loader.removeListener(stopListener);
            }
        }
        finally {
            this._owner = null;
            this._attributes = null;
            this._listeners = null;
            this._scanListeners = null;
            this._artifactManager = null;
            this._stopListener = null;
            EnvironmentAdmin admin = this._admin;
            this._admin = null;
            if (admin != null) {
                admin.unregister();
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this.getId());
        if (!this._lifecycle.isActive()) {
            sb.append(",");
            sb.append(this._lifecycle.getStateName());
        }
        sb.append("]");
        return sb.toString();
    }

    private static final Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(EnvironmentClassLoader.class.getName());
        }
        return _log;
    }

    private static ClassLoader getSystemClassLoaderSafe() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (Exception exception) {
            return EnvironmentClassLoader.class.getClassLoader();
        }
    }

    static {
        _childListenerLock = new Object();
    }

    class ResourceEntry {
        private URL _url;
        private long _expireTime;
        private Path _path;
        private boolean _isPathChecked;

        ResourceEntry(URL url) {
            this._url = url;
            this._expireTime = EnvironmentClassLoader.this.isDirectoryLoader() ? CurrentTime.getCurrentTime() + EnvironmentClassLoader.this.getDependencyCheckInterval() : 0x3FFFFFFFFFFFFFFFL;
        }

        public boolean isModified() {
            return this._expireTime < CurrentTime.getCurrentTime();
        }

        public URL getResource() {
            return this._url;
        }

        public InputStream getResourceAsStream() {
            if (this._url == null) {
                return null;
            }
            if (!this._isPathChecked) {
                String urlString = URLDecoder.decode(this._url.toString());
                if (urlString.startsWith("file:") || urlString.startsWith("jar:")) {
                    this._path = Vfs.getPwd(EnvironmentClassLoader.this).lookup(urlString);
                }
                this._isPathChecked = true;
            }
            try {
                if (this._path != null) {
                    return this._path.openRead();
                }
                return this._url.openStream();
            }
            catch (IOException e) {
                EnvironmentClassLoader.log().log(Level.FINE, e.toString(), e);
                return null;
            }
        }
    }

    static class ScanRoot {
        private final URL _url;
        private final String _pkg;

        ScanRoot(URL url, String pkg) {
            this._url = url;
            this._pkg = pkg;
        }

        URL getUrl() {
            return this._url;
        }

        String getPackageName() {
            return this._pkg;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._url + "," + this._pkg + "]";
        }
    }
}

