/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.Config;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.server.util.CauchoSystem;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.File;
import java.io.IOException;
import java.security.AllPermission;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class SystemClassLoader
extends EnvironmentClassLoader
implements EnvironmentBean {
    private static Logger _log;
    private AtomicBoolean _isInit = new AtomicBoolean();
    private boolean _hasBootClassPath;
    private Path _libexec;

    public SystemClassLoader(ClassLoader parent) {
        super(parent, "system", true);
        String smallmem;
        String preScan = System.getProperty("caucho.jar.prescan");
        if (!"false".equals(preScan)) {
            DynamicClassLoader.setJarCacheEnabled(true);
        }
        if ((smallmem = System.getProperty("caucho.smallmem")) != null && !"false".equals(smallmem)) {
            DynamicClassLoader.setJarCacheEnabled(false);
        }
    }

    @Override
    public boolean isJarCacheEnabled() {
        return DynamicClassLoader.isJarCacheEnabledDefault();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public void init() {
        if (this._isInit.getAndSet(true)) {
            return;
        }
        this.initSecurity();
        this.initClasspath();
        this._hasBootClassPath = false;
        super.init();
        String systemConf = System.getProperty("system.conf");
        if (systemConf != null) {
            try {
                Path path = Vfs.lookup(systemConf);
                Config config = new Config();
                config.configure((Object)this, path, this.getSchema());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex.toString());
            }
        }
    }

    private void initClasspath() {
        boolean isValid = false;
        try {
            String boot = System.getProperty("sun.boot.class.path");
            if (boot != null) {
                this.initClasspath(boot);
                this._hasBootClassPath = true;
                this.initExtDirs("java.ext.dirs");
                this.initExtDirs("java.endorsed.dirs");
            }
            this.initClasspath(System.getProperty("java.class.path"));
            isValid = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (!isValid) {
                this._hasBootClassPath = false;
            }
        }
    }

    private void initExtDirs(String prop) throws IOException {
        String extDirPath = System.getProperty(prop);
        if (extDirPath == null) {
            return;
        }
        for (String extDir : extDirPath.split(File.pathSeparator, 512)) {
            Path dir = Vfs.lookup(extDir);
            for (String fileName : dir.list()) {
                Path root = dir.lookup(fileName);
                try {
                    if (!root.isDirectory() && (!root.isFile() || !root.getPath().endsWith(".jar") && !root.getPath().endsWith(".zip"))) continue;
                    this.addRoot(root);
                }
                catch (Throwable e) {
                    this._hasBootClassPath = false;
                    e.printStackTrace();
                }
            }
        }
    }

    private void initClasspath(String classpath) {
        String[] classpathElements;
        for (String classpathElement : classpathElements = classpath.split(File.pathSeparator, 512)) {
            Path root = Vfs.lookup(classpathElement);
            try {
                if (!root.exists()) continue;
                this.addRoot(root);
            }
            catch (Throwable e) {
                this._hasBootClassPath = false;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void initEnvironment() {
    }

    @Override
    public Class<?> loadClassImpl(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl != null) {
            if (resolve) {
                this.resolveClass(cl);
            }
            return cl;
        }
        String className = name;
        if (this._hasBootClassPath && this.findPath(className = name.replace('.', '/') + ".class") == null) {
            return null;
        }
        try {
            return super.loadClassImpl(name, resolve);
        }
        catch (Error e) {
            className = name.replace('.', '/') + ".class";
            if (this.findPath(className) != null) {
                String msg = e + "\n  while loading " + name + " in " + this + "\n  which exists in " + this.findPath(className) + "\n  check for missing dependencies";
                SystemClassLoader.log().fine(msg);
                if (e instanceof NoClassDefFoundError) {
                    NoClassDefFoundError exn = new NoClassDefFoundError(msg);
                    exn.initCause(e);
                    throw exn;
                }
            }
            throw e;
        }
        catch (ClassNotFoundException e) {
            className = name.replace('.', '/') + ".class";
            if (this.findPath(className) != null) {
                String msg = e + "\n  " + name + " in " + this + "\n  exists in " + this.findPath(className) + "\n  check for missing dependencies";
                SystemClassLoader.log().fine(msg);
                throw new ClassNotFoundException(e.getMessage() + "\n" + msg, e);
            }
            throw e;
        }
    }

    protected String getSchema() {
        return "com/caucho/loader/system.rnc";
    }

    private Path getLibexec() {
        if (this._libexec == null) {
            this._libexec = CauchoSystem.isWindows() ? (CauchoSystem.is64Bit() ? CauchoSystem.getResinHome().lookup("win64") : CauchoSystem.getResinHome().lookup("win32")) : (CauchoSystem.is64Bit() ? CauchoSystem.getResinHome().lookup("libexec64") : CauchoSystem.getResinHome().lookup("libexec"));
        }
        return this._libexec;
    }

    @Override
    public String findLibrary(String name) {
        Path path = this.getLibexec().lookup("lib" + name + ".so");
        if (path.canRead()) {
            return path.getNativePath();
        }
        path = this.getLibexec().lookup("lib" + name + ".jnilib");
        if (path.canRead()) {
            return path.getNativePath();
        }
        path = this.getLibexec().lookup(name + ".dll");
        return super.findLibrary(name);
    }

    private void initSecurity() {
        this.addPermission(new AllPermission());
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(SystemClassLoader.class.getName());
        }
        return _log;
    }
}

