/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.maven;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.loader.module.Artifact;
import com.caucho.loader.module.ArtifactDependency;
import com.caucho.loader.module.ArtifactVersion;
import com.caucho.loader.module.ArtifactVersionRange;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

public class MavenProject {
    private static final L10N L = new L10N(MavenProject.class);
    private String _groupId;
    private String _artifactId;
    private ArtifactVersion _version;
    private Parent _parent;
    private ArrayList<ArtifactDependency> _dependencyList = new ArrayList();

    public void setGroupId(String groupId) {
        this._groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this._artifactId = artifactId;
    }

    public void setVersion(String version) {
        this._version = ArtifactVersion.create(version);
    }

    public void addParent(Parent parent) {
        this._parent = parent;
    }

    public Dependencies createDependencies() {
        return new Dependencies();
    }

    public void addBuilderProgram(ConfigProgram program) {
    }

    void addArtifactDependency(ArtifactDependency dependency) {
        this._dependencyList.add(dependency);
    }

    @PostConstruct
    public void init() {
        if (this._groupId == null && this._parent != null) {
            this._groupId = this._parent.getGroupId();
        }
        if (this._groupId == null) {
            throw new ConfigException(L.l("<groupId> is a required attribute of Maven <project>"));
        }
        if (this._artifactId == null) {
            throw new ConfigException(L.l("<artifactId> is a required attribute of Maven <project>"));
        }
        if (this._version == null && this._parent != null) {
            this._version = this._parent.getVersion();
        }
        if (this._version == null) {
            throw new ConfigException(L.l("<version> is a required attribute of Maven <project>"));
        }
    }

    public Artifact toArtifact(Path path) {
        ArtifactDependency parent = null;
        if (this._parent != null) {
            ArtifactVersion parentVersion = this._parent.getVersion();
            ArtifactVersionRange parentRange = new ArtifactVersionRange(parentVersion, true, parentVersion, true);
            parent = new ArtifactDependency(this._parent.getGroupId(), null, this._parent.getArtifactId(), parentRange);
        }
        return new Artifact(path, this._groupId, null, this._artifactId, this._version, parent, this._dependencyList);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[group=" + this._groupId + ",artifact=" + this._artifactId + ",version=" + this._version + "]";
    }

    public class Dependency {
        private String _groupId;
        private String _artifactId;
        private ArtifactVersionRange _version;

        public void setGroupId(String groupId) {
            this._groupId = groupId;
        }

        public void setArtifactId(String artifactId) {
            this._artifactId = artifactId;
        }

        public void setVersion(String version) {
            this._version = ArtifactVersionRange.create(version);
        }

        public void addBuilderProgram(ConfigProgram program) {
        }

        @PostConstruct
        public void init() {
            if (this._groupId == null) {
                throw new ConfigException(L.l("<groupId> is required in a <dependency> in a Maven pom.xml file"));
            }
            if (this._artifactId == null) {
                throw new ConfigException(L.l("<artifactId> is required in a <dependency> in a Maven pom.xml file"));
            }
            ArtifactDependency dependency = new ArtifactDependency(this._groupId, null, this._artifactId, this._version);
            MavenProject.this.addArtifactDependency(dependency);
        }
    }

    public class Dependencies {
        public Dependency createDependency() {
            return new Dependency();
        }

        public void addBuilderProgram(ConfigProgram program) {
        }
    }

    public static class Parent {
        private String _groupId;
        private String _artifactId;
        private ArtifactVersion _version;

        public void setGroupId(String groupId) {
            this._groupId = groupId;
        }

        public String getGroupId() {
            return this._groupId;
        }

        public void setArtifactId(String artifactId) {
            this._artifactId = artifactId;
        }

        public String getArtifactId() {
            return this._artifactId;
        }

        public void setVersion(String version) {
            this._version = ArtifactVersion.create(version);
        }

        public ArtifactVersion getVersion() {
            return this._version;
        }

        public void addBuilderProgram(ConfigProgram program) {
        }

        @PostConstruct
        public void init() {
            if (this._groupId == null) {
                throw new ConfigException(L.l("<groupId> is a required attribute of <parent>"));
            }
            if (this._artifactId == null) {
                throw new ConfigException(L.l("<artifactId> is a required attribute of <parent>"));
            }
            if (this._version == null) {
                throw new ConfigException(L.l("<version> is a required attribute of <parent>"));
            }
        }
    }
}

