/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.module;

import com.caucho.loader.module.ArtifactVersionRange;
import com.caucho.util.L10N;

public class ArtifactDependency {
    private static final L10N L = new L10N(ArtifactDependency.class);
    private final String _org;
    private final String _module;
    private final String _name;
    private final ArtifactVersionRange _version;

    public ArtifactDependency(String org, String module, String name, ArtifactVersionRange version) {
        this._org = org;
        if (org == null) {
            throw new NullPointerException(L.l("artifact org cannot be null"));
        }
        this._module = module;
        this._name = name;
        if (name == null) {
            throw new NullPointerException(L.l("artifact name cannot be null"));
        }
        this._version = version;
    }

    public String getOrg() {
        return this._org;
    }

    public String getName() {
        return this._name;
    }

    public ArtifactVersionRange getVersion() {
        return this._version;
    }

    public boolean isSameArtifact(ArtifactDependency dependency) {
        if (!this.getOrg().equals(dependency.getOrg())) {
            return false;
        }
        return this.getName().equals(dependency.getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[org=" + this._org + ",name=" + this._name + ",version=" + this._version + "]";
    }
}

