/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.module;

import com.caucho.config.ConfigException;
import com.caucho.inject.Module;
import com.caucho.loader.EnvironmentApply;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.module.Artifact;
import com.caucho.loader.module.ArtifactClassLoader;
import com.caucho.loader.module.ArtifactDependency;
import com.caucho.loader.module.ArtifactRepository;
import com.caucho.util.L10N;
import java.net.URL;
import java.util.ArrayList;

@Module
public class ArtifactManager {
    private static final L10N L = new L10N(ArtifactManager.class);
    private EnvironmentClassLoader _loader;
    private ArrayList<ArtifactDependency> _dependencyList = new ArrayList();
    private ArrayList<ArtifactDependency> _pendingList = new ArrayList();
    private ArrayList<Artifact> _artifactList = new ArrayList();
    private ArrayList<Entry> _entryList = new ArrayList();
    private ArrayList<ArtifactClassLoader> _loaderList = new ArrayList();

    public ArtifactManager(EnvironmentClassLoader loader) {
        this._loader = loader;
    }

    public void addDependency(ArtifactDependency dependency) {
        ArtifactRepository repository = ArtifactRepository.getCurrent();
        if (repository == null) {
            throw new ConfigException(L.l("Artifact dependency org='{0}', name='{1}' is not valid because no artifact repositories have been defined", (Object)dependency.getOrg(), (Object)dependency.getName()));
        }
        ArrayList<Artifact> artifactList = repository.resolve(dependency);
        if (artifactList == null || artifactList.size() == 0) {
            ArtifactDependency plainDependency = new ArtifactDependency(dependency.getOrg(), null, dependency.getName(), null);
            artifactList = repository.resolve(plainDependency);
            throw new ConfigException(L.l("Artifact dependency '{0}', org='{1}', version={2} does not match any jars in the repository.  Available artifacts:{3}", (Object)dependency.getName(), (Object)dependency.getOrg(), (Object)dependency.getVersion().toDebugString(), (Object)this.toArtifactList(artifactList)));
        }
        this._dependencyList.add(dependency);
        this._pendingList.add(dependency);
    }

    private String toArtifactList(ArrayList<Artifact> artifactList) {
        StringBuilder sb = new StringBuilder();
        for (Artifact artifact : artifactList) {
            sb.append("\n  ").append(artifact.getName());
            sb.append(", org=").append(artifact.getOrg());
            if (artifact.getVersion() == null) continue;
            sb.append(", version=").append(artifact.getVersion().toDebugString());
        }
        return sb.toString();
    }

    public void start() {
        this.resolve();
    }

    public Class findImportClass(String name) {
        this.resolve();
        for (int i = 0; i < this._entryList.size(); ++i) {
            Entry entry = this._entryList.get(i);
            try {
                Class<?> cl = entry.getLoader().findClassImpl(name);
                if (cl == null) continue;
                return cl;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getImportResource(String name) {
        this.resolve();
        return null;
    }

    public void buildImportClassPath(ArrayList<String> cp) {
        this.resolve();
        for (Entry entry : this._entryList) {
            entry.getLoader().buildClassPathImpl(cp);
        }
    }

    public void applyVisibleModules(EnvironmentApply apply) {
        this.resolve();
        for (Entry entry : this._entryList) {
            apply.apply(entry.getLoader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        ArtifactManager artifactManager = this;
        synchronized (artifactManager) {
            if (this._pendingList.size() == 0) {
                return;
            }
            ArrayList<ArtifactDependency> pendingList = new ArrayList<ArtifactDependency>(this._pendingList);
            ArtifactRepository repository = ArtifactRepository.getCurrent();
            ArrayList<Artifact> newArtifactList = new ArrayList<Artifact>();
            for (ArtifactDependency depend : pendingList) {
                ArrayList<Artifact> artifacts = repository.resolve(depend, this._dependencyList);
                Artifact artifact = artifacts.get(0);
                this._artifactList.add(artifact);
                newArtifactList.add(artifact);
            }
            for (Artifact artifact : newArtifactList) {
                ArrayList<Artifact> createList = new ArrayList<Artifact>();
                ArtifactClassLoader loader = this.createLoader(this._loader.getParent(), artifact, this._artifactList, createList);
                this._entryList.add(new Entry(artifact, loader));
            }
        }
        for (Entry entry : this._entryList) {
            entry.getLoader().start();
        }
    }

    private ArtifactClassLoader createLoader(ClassLoader parent, Artifact artifact, ArrayList<Artifact> artifactList, ArrayList<Artifact> createList) {
        if (createList.contains(artifact)) {
            throw new ConfigException(L.l("Dependency loop detected at {0} while creating artifact {1}", (Object)artifact, (Object)createList.get(0)));
        }
        createList.add(artifact);
        ArtifactRepository repository = ArtifactRepository.getCurrent();
        ArrayList<ArtifactClassLoader> importList = new ArrayList<ArtifactClassLoader>();
        ArrayList<Artifact> subArtifactList = new ArrayList<Artifact>();
        ArrayList<ArtifactDependency> dependencies = this.getArtifactDependencies(artifact);
        for (ArtifactDependency depend : dependencies) {
            ArrayList<Artifact> artifacts = repository.resolve(depend, dependencies);
            if (artifacts.size() == 0) {
                throw new ConfigException(L.l("Dependency org={0}, name={1} does not have any matching artifacts", (Object)depend.getOrg(), (Object)depend.getName()));
            }
            Artifact subArtifact = this.findArtifact(artifacts.get(0), artifactList);
            subArtifactList.add(subArtifact);
        }
        for (Artifact subArtifact : subArtifactList) {
            importList.add(this.createLoader(parent, subArtifact, subArtifactList, createList));
        }
        createList.remove(artifact);
        ArtifactClassLoader loader = this.findLoader(artifact);
        if (loader == null) {
            loader = new ArtifactClassLoader(this._loader.getParent(), artifact, importList);
            this._loaderList.add(loader);
        }
        return loader;
    }

    private ArrayList<ArtifactDependency> getArtifactDependencies(Artifact artifact) {
        ArrayList<ArtifactDependency> dependencies = new ArrayList<ArtifactDependency>();
        ArtifactDependency parentDep = artifact.getParent();
        if (parentDep != null) {
            ArtifactRepository repository = ArtifactRepository.getCurrent();
            ArrayList<Artifact> parentList = repository.resolve(parentDep);
            if (parentList == null || parentList.size() == 0) {
                throw new ConfigException(L.l("maven parent {0} cannot be resolved", (Object)parentDep));
            }
            Artifact parent = parentList.get(0);
            dependencies.addAll(this.getArtifactDependencies(parent));
        }
        for (ArtifactDependency dep : artifact.getDependencies()) {
            dependencies.add(dep);
        }
        return dependencies;
    }

    private Artifact findArtifact(Artifact newArtifact, ArrayList<Artifact> artifactList) {
        for (Artifact artifact : artifactList) {
            if (!newArtifact.isSameArtifact(artifact)) continue;
            return artifact;
        }
        return newArtifact;
    }

    private ArtifactClassLoader findLoader(Artifact artifact) {
        for (ArtifactClassLoader loader : this._loaderList) {
            if (!loader.getArtifact().equals(artifact)) continue;
            return loader;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._loader + "]";
    }

    static class Entry {
        private Artifact _artifact;
        private ArtifactClassLoader _loader;

        Entry(Artifact artifact, ArtifactClassLoader loader) {
            this._artifact = artifact;
            this._loader = loader;
        }

        ArtifactClassLoader getLoader() {
            return this._loader;
        }
    }
}

