/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.log.AbstractLogHandler;
import com.caucho.log.RotateLog;
import com.caucho.log.TimestampFilter;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import javax.annotation.PostConstruct;

@Configurable
public class PathHandler
extends AbstractLogHandler {
    private final RotateLog _pathLog = new RotateLog();
    private Formatter _formatter;
    private String _timestamp = "[%Y/%m/%d %H:%M:%S.%s] ";
    private WriteStream _os;

    public PathHandler() {
    }

    public PathHandler(Path path) {
        this();
        this.setPath(path);
        this.init();
    }

    public PathHandler(String path) {
        this(Vfs.lookup(path));
    }

    public void setPath(Path path) {
        this._pathLog.setPath(path);
    }

    public void setPathFormat(String pathFormat) {
        this._pathLog.setPathFormat(pathFormat);
    }

    public void setArchiveFormat(String archiveFormat) {
        this._pathLog.setArchiveFormat(archiveFormat);
    }

    public void setRolloverPeriod(Period rolloverPeriod) {
        this._pathLog.setRolloverPeriod(rolloverPeriod);
    }

    public void setRolloverSize(Bytes size) {
        this._pathLog.setRolloverSize(size);
    }

    public void setRolloverCount(int count) {
        this._pathLog.setRolloverCount(count);
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    @Override
    public void setFormatter(Formatter formatter) {
        this._formatter = formatter;
    }

    @PostConstruct
    public void init() throws ConfigException {
        try {
            String encoding;
            this._pathLog.init();
            WriteStream os = this._pathLog.getRotateStream().getStream();
            if (this._timestamp != null) {
                TimestampFilter filter = new TimestampFilter();
                filter.setTimestamp(this._timestamp);
                filter.setStream(os);
                os = new WriteStream(filter);
            }
            if ((encoding = System.getProperty("file.encoding")) != null) {
                os.setEncoding(encoding);
            }
            os.setDisableClose(true);
            this._os = os;
        }
        catch (IOException e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPublish(LogRecord record) {
        WriteStream writeStream = this._os;
        synchronized (writeStream) {
            try {
                if (this._formatter != null) {
                    String value = this._formatter.format(record);
                    this._os.println(value);
                    return;
                }
                String message = record.getMessage();
                Throwable thrown = record.getThrown();
                if (thrown != null) {
                    if (message != null && !message.equals(thrown.toString()) && !message.equals(thrown.getMessage())) {
                        this.printMessage(this._os, message, record.getParameters());
                    }
                    record.getThrown().printStackTrace(this._os.getPrintWriter());
                } else {
                    this.printMessage(this._os, message, record.getParameters());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFlush() {
        WriteStream writeStream = this._os;
        synchronized (writeStream) {
            try {
                this._os.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int hashCode() {
        if (this._os == null || this._os.getPath() == null) {
            return super.hashCode();
        }
        return this._os.getPath().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PathHandler handler = (PathHandler)o;
        if (this._os == null || handler._os == null) {
            return false;
        }
        return this._os.getPath().equals(handler._os.getPath());
    }

    @Override
    public String toString() {
        if (this._os == null) {
            return this.getClass().getSimpleName() + "[" + this._pathLog + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._os.getPath() + "]";
    }
}

