/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.jmx.Description;
import com.caucho.jmx.Jmx;
import com.caucho.management.server.ManagedObjectMXBean;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class AbstractManagedObject
implements ManagedObjectMXBean {
    private static final Logger log = Logger.getLogger(AbstractManagedObject.class.getName());
    private transient ClassLoader _classLoader;
    private ObjectName _objectName;

    protected AbstractManagedObject() {
        this(Thread.currentThread().getContextClassLoader());
    }

    protected AbstractManagedObject(ClassLoader loader) {
        this._classLoader = loader;
    }

    @Override
    @Description(value="The JMX ObjectName for the MBean")
    public ObjectName getObjectName() {
        if (this._objectName == null) {
            try {
                LinkedHashMap<String, String> props = Jmx.copyContextProperties(this._classLoader);
                props.put("type", this.getType());
                String name = this.getName();
                if (name != null) {
                    if (name.indexOf(58) >= 0) {
                        name = ObjectName.quote(name);
                    }
                    props.put("name", name);
                }
                this.addObjectNameProperties(props);
                this._objectName = Jmx.getObjectName("resin", props);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        }
        return this._objectName;
    }

    protected void addObjectNameProperties(Map<String, String> props) throws MalformedObjectNameException {
    }

    @Override
    public abstract String getName();

    @Override
    public String getType() {
        Class<?>[] interfaces = this.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String className = interfaces[i].getName();
            if (!className.endsWith("MXBean")) continue;
            int p = className.lastIndexOf(46);
            int q = className.indexOf("MXBean");
            return className.substring(p + 1, q);
        }
        int p = this.getClass().getName().lastIndexOf(46);
        return this.getClass().getName().substring(p + 1);
    }

    protected boolean registerSelf() {
        try {
            Jmx.register((Object)this, this.getObjectName(), this._classLoader);
            return true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
    }

    protected boolean unregisterSelf() {
        try {
            Jmx.unregister(this.getObjectName(), this._classLoader);
            return true;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getObjectName() + "]";
    }
}

