/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.tourmaline;

import com.caucho.message.MessageEncoder;
import com.caucho.message.MessagePropertiesFactory;
import com.caucho.message.broker.BrokerSender;
import com.caucho.message.common.AbstractMessageSender;
import com.caucho.message.tourmaline.NautilusClientSenderEndpoint;
import com.caucho.message.tourmaline.NautilusSenderFactory;
import com.caucho.remote.websocket.WebSocketClient;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;

public class NautilusClientSender<T>
extends AbstractMessageSender<T> {
    private static final L10N L = new L10N(NautilusClientSender.class);
    private final String _address;
    private final String _queue;
    private final MessageEncoder<T> _encoder;
    private BrokerSender _publisher;
    private long _lastMessageId;
    private NautilusClientSenderEndpoint<T> _endpoint;
    private WriteStream _os;

    NautilusClientSender(NautilusSenderFactory factory) {
        super(factory);
        this._address = factory.getAddress();
        this._encoder = factory.getMessageEncoder();
        int q = this._address.indexOf("?queue=");
        this._queue = this._address.substring(q + "?queue=".length());
        this.connect();
    }

    public String getAddress() {
        return this._address;
    }

    MessageEncoder<T> getEncoder() {
        return this._encoder;
    }

    private void connect() {
        try {
            this._endpoint = new NautilusClientSenderEndpoint(this);
            WebSocketClient client = new WebSocketClient(this._address, this._endpoint);
            client.connect();
            this._endpoint.sendPublish(this._queue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this._os = new WriteStream();
        this._os.setReuseBuffer(true);
    }

    @Override
    protected boolean offerMicros(MessagePropertiesFactory<T> factory, T value, long timeoutMicros) {
        this._endpoint.send(factory, value, timeoutMicros);
        return true;
    }

    @Override
    public long getLastMessageId() {
        return this._lastMessageId;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public void close() {
        NautilusClientSenderEndpoint<T> endpoint = this._endpoint;
        this._endpoint = null;
        if (endpoint != null) {
            endpoint.close();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }
}

