/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.balance;

import com.caucho.util.CurrentTime;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ClientNetworkState {
    private final String _id;
    private final long _recoverTimeout;
    private final AtomicReference<State> _state = new AtomicReference<State>(State.ACTIVE);
    private AtomicLong _dynamicRecoverTimeout = new AtomicLong();
    private AtomicInteger _connectionCount = new AtomicInteger();
    private volatile long _firstFailTime;
    private volatile long _lastFailTime;
    private volatile long _firstSuccessTime;

    public ClientNetworkState(String id, long recoverTimeout) {
        this._id = id;
        this._recoverTimeout = recoverTimeout;
    }

    public String getId() {
        return this._id;
    }

    public long getRecoverTimeout() {
        return this._recoverTimeout;
    }

    public final String getState() {
        return String.valueOf(this._state);
    }

    public final boolean isActive() {
        return this._state.get().isActive();
    }

    public boolean isEnabled() {
        return this._state.get().isEnabled();
    }

    public final boolean isDead() {
        return !this.isActive();
    }

    public void enable() {
        this.toState(State.ENABLED);
    }

    public void disable() {
        this.toState(State.DISABLED);
        this._firstSuccessTime = 0L;
    }

    public void onSuccess() {
        if (this._firstSuccessTime <= 0L) {
            this._firstSuccessTime = CurrentTime.getCurrentTime();
        }
        this._dynamicRecoverTimeout.set(1000L);
        this._firstFailTime = 0L;
    }

    public void onFail() {
        this._lastFailTime = CurrentTime.getCurrentTime();
        if (this._firstFailTime == 0L) {
            this._firstFailTime = this._lastFailTime;
        }
        this._firstSuccessTime = 0L;
        this.toState(State.FAIL);
        long recoverTimeout = this._dynamicRecoverTimeout.get();
        long nextRecoverTimeout = Math.min(recoverTimeout + 1000L, this._recoverTimeout);
        this._dynamicRecoverTimeout.compareAndSet(recoverTimeout, nextRecoverTimeout);
    }

    public boolean startConnection() {
        int count;
        long recoverTimeout;
        long lastFailTime;
        State state = this._state.get();
        if (state.isActive()) {
            this._connectionCount.incrementAndGet();
            return true;
        }
        long now = CurrentTime.getCurrentTime();
        if (now < (lastFailTime = this._lastFailTime) + (recoverTimeout = this._dynamicRecoverTimeout.get())) {
            return false;
        }
        do {
            if ((count = this._connectionCount.get()) <= 0) continue;
            return false;
        } while (!this._connectionCount.compareAndSet(count, count + 1));
        return true;
    }

    public void completeConnection() {
        this._connectionCount.decrementAndGet();
    }

    public void close() {
        this.toState(State.CLOSED);
    }

    private State toState(State targetState) {
        State newState;
        State oldState;
        while (!this._state.compareAndSet(oldState = this._state.get(), newState = targetState.toState(oldState))) {
        }
        return this._state.get();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    static enum State {
        ACTIVE{

            @Override
            boolean isActive() {
                return true;
            }

            @Override
            boolean isEnabled() {
                return true;
            }

            @Override
            State toState(State state) {
                return state.toActive();
            }

            @Override
            State toFail() {
                return FAIL;
            }

            @Override
            State toDisable() {
                return DISABLED;
            }
        }
        ,
        FAIL{

            @Override
            boolean isEnabled() {
                return true;
            }

            @Override
            State toState(State state) {
                return state.toFail();
            }

            @Override
            State toActive() {
                return ACTIVE;
            }

            @Override
            State toDisable() {
                return DISABLED;
            }
        }
        ,
        DISABLED{

            @Override
            State toState(State state) {
                return state.toDisable();
            }

            @Override
            State toActive() {
                return this;
            }

            @Override
            State toFail() {
                return this;
            }

            @Override
            State toEnable() {
                return ACTIVE;
            }
        }
        ,
        ENABLED{

            @Override
            State toState(State state) {
                return state.toEnable();
            }
        }
        ,
        CLOSED{

            @Override
            boolean isClosed() {
                return true;
            }

            @Override
            State toState(State state) {
                return CLOSED;
            }

            @Override
            State toActive() {
                return this;
            }

            @Override
            State toFail() {
                return this;
            }

            @Override
            State toEnable() {
                return this;
            }

            @Override
            State toDisable() {
                return this;
            }
        };


        boolean isActive() {
            return false;
        }

        boolean isEnabled() {
            return false;
        }

        boolean isClosed() {
            return false;
        }

        State toActive() {
            return this;
        }

        State toFail() {
            return this;
        }

        State toEnable() {
            return this;
        }

        State toDisable() {
            return DISABLED;
        }

        State toState(State state) {
            throw new UnsupportedOperationException(this.toString());
        }
    }
}

