/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.network.listen.AsyncController;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.SocketLinkCometListener;
import com.caucho.network.listen.SocketLinkState;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public abstract class AbstractSocketLink
implements SocketLink {
    private final ReadStream _readStream = new ReadStream();
    private final WriteStream _writeStream;

    public AbstractSocketLink() {
        this._readStream.setReuseBuffer(true);
        this._writeStream = new WriteStream();
        this._writeStream.setReuseBuffer(true);
    }

    @Override
    public abstract int getId();

    @Override
    public final ReadStream getReadStream() {
        return this._readStream;
    }

    @Override
    public final WriteStream getWriteStream() {
        return this._writeStream;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public String getVirtualHost() {
        return null;
    }

    @Override
    public abstract InetAddress getLocalAddress();

    @Override
    public String getLocalHost() {
        InetAddress localAddress = this.getLocalAddress();
        if (localAddress != null) {
            return localAddress.getHostAddress();
        }
        return null;
    }

    @Override
    public abstract int getLocalPort();

    @Override
    public abstract InetAddress getRemoteAddress();

    @Override
    public String getRemoteHost() {
        InetAddress remoteAddress = this.getRemoteAddress();
        if (remoteAddress != null) {
            return remoteAddress.getHostAddress();
        }
        return null;
    }

    @Override
    public int getRemoteAddress(byte[] buffer, int offset, int length) {
        InetAddress remote = this.getRemoteAddress();
        String name = remote.getHostAddress();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            buffer[offset + i] = (byte)name.charAt(i);
        }
        return len;
    }

    @Override
    public abstract int getRemotePort();

    @Override
    public String getCipherSuite() {
        return null;
    }

    @Override
    public String getSslProtocol() {
        return null;
    }

    @Override
    public int getKeySize() {
        return 0;
    }

    @Override
    public X509Certificate[] getClientCertificates() throws CertificateException {
        return null;
    }

    @Override
    public boolean isKeepaliveAllocated() {
        return false;
    }

    @Override
    public void killKeepalive(String reason) {
    }

    @Override
    public void requestShutdownBegin() {
    }

    @Override
    public void requestShutdownEnd() {
    }

    public SocketLinkState getState() {
        return SocketLinkState.REQUEST_ACTIVE_KA;
    }

    @Override
    public boolean isCometActive() {
        return false;
    }

    @Override
    public boolean isCometSuspend() {
        return false;
    }

    @Override
    public boolean isDuplex() {
        return false;
    }

    @Override
    public AsyncController toComet(SocketLinkCometListener cometHandler) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public AsyncController toCometRestart(SocketLinkCometListener cometHandler) {
        return this.toComet(cometHandler);
    }
}

