/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.SQLExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class AbstractResultSet
implements ResultSet {
    private static final L10N L = new L10N(AbstractResultSet.class);
    private static final FreeList<QDate> _freeDate = new FreeList(16);
    private int _rowNumber;

    @Override
    public abstract Statement getStatement() throws SQLException;

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract boolean next() throws SQLException;

    @Override
    public abstract boolean wasNull() throws SQLException;

    @Override
    public abstract int findColumn(String var1) throws SQLException;

    @Override
    public abstract String getString(int var1) throws SQLException;

    @Override
    public boolean absolute(int row) throws SQLException {
        if (row < this.getRow()) {
            return false;
        }
        while (this.getRow() < row) {
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void afterLast() {
    }

    @Override
    public void beforeFirst() {
    }

    @Override
    public void cancelRowUpdates() {
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void deleteRow() {
    }

    @Override
    public int getRow() throws SQLException {
        if (this._rowNumber < 0) {
            throw new SQLException("can't call getRow() after close()");
        }
        return this._rowNumber;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.getRow() == 0;
    }

    @Override
    public boolean isAfterLast() {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this._rowNumber == 1;
    }

    @Override
    public boolean first() throws SQLException {
        return this.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        return this.isLast();
    }

    @Override
    public int getConcurrency() {
        return 0;
    }

    @Override
    public String getCursorName() {
        return null;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex).setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        String v = this.getString(columnIndex);
        return v != null && !v.equals("") && !v.equals("0") && !v.equals("n");
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (byte)this.getInt(columnIndex);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            int length;
            Blob blob = this.getBlob(columnIndex);
            if (blob == null) {
                return null;
            }
            byte[] bytes = new byte[length];
            InputStream is = blob.getBinaryStream();
            try {
                int sublen;
                int offset = 0;
                for (length = (int)blob.length(); length > 0 && (sublen = is.read(bytes, offset, length)) > 0; length -= sublen) {
                    offset += sublen;
                }
            }
            finally {
                is.close();
            }
            return bytes;
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper(e);
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        String v = this.getString(columnIndex);
        if (v == null || v.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(v);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() {
        return 0;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return (float)this.getDouble(columnIndex);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return (float)this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String v = this.getString(columnIndex);
        if (v == null || v.length() == 0) {
            return 0;
        }
        return Integer.parseInt(v);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String v = this.getString(columnIndex);
        if (v == null || v.length() == 0) {
            return 0L;
        }
        return Long.parseLong(v);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (short)this.getInt(columnIndex);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnName, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(columnName), calendar);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String value = this.getString(columnIndex);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            QDate qDate = _freeDate.allocate();
            if (qDate == null) {
                qDate = new QDate();
            }
            long date = qDate.parseLocalDate(value);
            _freeDate.free(qDate);
            return new Timestamp(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), calendar);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Blob blob = this.getBlob(columnIndex);
        if (blob != null) {
            return blob.getBinaryStream();
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        return this.getArray(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void insertRow() {
    }

    @Override
    public void moveToCurrentRow() {
    }

    @Override
    public void moveToInsertRow() {
    }

    @Override
    public boolean previous() {
        return false;
    }

    @Override
    public void refreshRow() {
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        while (rows-- > 0) {
            this.next();
        }
        return false;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public void updateRow() {
    }

    @Override
    public void updateObject(int columnIndex, Object o) {
    }

    @Override
    public void updateObject(String columnName, Object o) throws SQLException {
        this.updateObject(this.findColumn(columnName), o);
    }

    @Override
    public void updateObject(int columnIndex, Object o, int scale) {
    }

    @Override
    public void updateObject(String columnName, Object o, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), o, scale);
    }

    @Override
    public void updateNull(int columnIndex) {
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) {
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) {
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) {
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) {
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) {
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    @Override
    public void updateShort(int columnIndex, short x) {
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(int columnIndex, int x) {
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateLong(int columnIndex, long x) {
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) {
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) {
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(int columnIndex, String x) {
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) {
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) {
    }

    @Override
    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), x, length);
    }

    @Override
    public void updateTime(int columnIndex, Time time) throws SQLException {
    }

    @Override
    public void updateTime(String columnName, Time time) throws SQLException {
        this.updateTime(this.findColumn(columnName), time);
    }

    @Override
    public void updateDate(int columnIndex, Date date) throws SQLException {
    }

    @Override
    public void updateDate(String columnName, Date date) throws SQLException {
        this.updateDate(this.findColumn(columnName), date);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp time) throws SQLException {
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp time) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), time);
    }

    @Override
    public void updateArray(int columnIndex, Array value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String columnName, Array value) throws SQLException {
        this.updateArray(this.findColumn(columnName), value);
    }

    @Override
    public void updateBlob(int columnIndex, Blob value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnName, Blob value) throws SQLException {
        this.updateBlob(this.findColumn(columnName), value);
    }

    @Override
    public void updateClob(int columnIndex, Clob value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnName, Clob value) throws SQLException {
        this.updateClob(this.findColumn(columnName), value);
    }

    @Override
    public void updateRef(int columnIndex, Ref value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String columnName, Ref value) throws SQLException {
        this.updateRef(this.findColumn(columnName), value);
    }

    @Override
    public URL getURL(int column) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String column) throws SQLException {
        return this.getURL(this.findColumn(column));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public void close() throws SQLException {
    }
}

