/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

import com.caucho.quercus.mysql.MysqlConnectionImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Logger;

class MysqlWriter {
    protected static final Logger log = Logger.getLogger(MysqlWriter.class.getName());
    protected static final L10N L = new L10N(MysqlWriter.class);
    private MysqlConnectionImpl _conn;
    private WriteStream _out;
    private int _packetLength;
    private int _packetNumber;

    MysqlWriter(MysqlConnectionImpl conn, WriteStream out) {
        this._conn = conn;
        this._out = out;
    }

    void startVariablePacket() throws IOException {
        WriteStream out = this._out;
        out.flush();
        assert (out.getBufferOffset() == 0);
        out.setBufferOffset(4);
    }

    void endVariablePacket() throws IOException {
        WriteStream out = this._out;
        int len = out.getBufferOffset() - 4;
        byte[] buffer = out.getBuffer();
        buffer[0] = (byte)len;
        buffer[1] = (byte)(len >> 8);
        buffer[2] = (byte)(len >> 16);
        buffer[3] = 1;
    }

    void writeByte(int value) throws IOException {
        WriteStream out = this._out;
        out.write(value);
    }

    void writeInt(int value) throws IOException {
        WriteStream out = this._out;
        out.write(value);
        out.write(value >> 8);
        out.write(value >> 16);
        out.write(value >> 24);
    }

    void writeZero(int len) throws IOException {
        WriteStream out = this._out;
        for (int i = 0; i < len; ++i) {
            out.write(0);
        }
    }

    void writeNullTermString(String s) throws IOException {
        WriteStream out = this._out;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            out.write((byte)ch);
        }
        out.write(0);
    }

    void write(String s) throws IOException {
        WriteStream out = this._out;
        out.printLatin1(s);
    }

    void writeLengthCodedBinary(long value) throws IOException {
        WriteStream out = this._out;
        if (value <= 250L) {
            out.write((int)value);
        } else if (value <= 65535L) {
            out.write(252);
            out.write((int)value);
            out.write((int)(value >> 8));
        } else if (value <= 0xFFFFFFL) {
            out.write(253);
            out.write((int)value);
            out.write((int)(value >> 8));
            out.write((int)(value >> 16));
        } else {
            out.write(254);
            out.write((int)value);
            out.write((int)(value >> 8));
            out.write((int)(value >> 16));
            out.write((int)(value >> 24));
            out.write((int)(value >> 32));
            out.write((int)(value >> 40));
            out.write((int)(value >> 48));
            out.write((int)(value >> 56));
        }
    }

    void write(byte[] buffer, int offset, int length) throws IOException {
        WriteStream out = this._out;
        out.write(buffer, offset, length);
    }

    void flush() throws IOException {
        WriteStream out = this._out;
        out.flush();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._out + "]";
    }
}

