/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

import com.caucho.quercus.mysql.MysqlConnectionImpl;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

public class QuercusMysqlDriver
implements Driver {
    private static final L10N L = new L10N(QuercusMysqlDriver.class);
    private String _url;
    private String _host = "localhost";
    private int _port = 3306;
    private String _database;

    public void setUrl(String url) {
        this._url = url;
        this.parseUrl(url);
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getDatabase() {
        return this._database;
    }

    @Override
    public boolean acceptsURL(String url) {
        return false;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return new MysqlConnectionImpl(this, url, info);
    }

    @Override
    public int getMajorVersion() {
        return 5;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    private void parseUrl(String url) {
        if (url.startsWith("jdbc:mysql://")) {
            this.parseUrlCompat(url);
            return;
        }
        int p = url.indexOf(58);
        String scheme = url.substring(0, p);
        if (!"quercus-mysql".equals(scheme)) {
            throw new IllegalArgumentException(L.l("'{0}' is an illegal mysql scheme", (Object)url));
        }
        int q = url.indexOf(58, p + 1);
        int r = url.indexOf(58, q + 1);
        if (q < 0) {
            throw new IllegalArgumentException(L.l("'{0}' is an illegal mysql URL", (Object)url));
        }
        this._host = url.substring(p + 1, q);
        if (r < 0) {
            this._port = Integer.parseInt(url.substring(q + 1));
        } else {
            this._port = Integer.parseInt(url.substring(q + 1, r));
            this._database = url.substring(r + 1);
        }
    }

    private void parseUrlCompat(String url) {
        if (!url.startsWith("jdbc:mysql://")) {
            throw new IllegalArgumentException(L.l("'{0}' is an illegal mysql scheme", (Object)url));
        }
        int p = url.indexOf("://");
        int q = url.indexOf(58, p + 3);
        int r = url.indexOf(47, q + 1);
        if (q < 0) {
            throw new IllegalArgumentException(L.l("'{0}' is an illegal mysql URL", (Object)url));
        }
        this._host = url.substring(p + 3, q);
        if (r < 0) {
            this._port = Integer.parseInt(url.substring(q + 1));
        } else {
            this._port = Integer.parseInt(url.substring(q + 1, r));
            this._database = url.substring(r + 1);
            p = this._database.indexOf(63);
            if (p == 0) {
                this._database = null;
            } else if (p > 0) {
                this._database = this._database.substring(0, p);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._host + ":" + this._port + "," + this._database + "]";
    }
}

