/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.ResinQuercus;
import com.caucho.quercus.servlet.QuercusServletImpl;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.resin.Resin;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class ResinQuercusServlet
extends QuercusServletImpl {
    private static final L10N L = new L10N(ResinQuercusServlet.class);
    private static final Logger log = Logger.getLogger(ResinQuercusServlet.class.getName());
    private WebApp _webApp;

    protected void initImpl(ServletConfig config) throws ServletException {
        this._webApp = (WebApp)config.getServletContext();
        ResinQuercus quercus = (ResinQuercus)this.getQuercus();
        quercus.setWebApp(this._webApp);
        this.getQuercus().setPwd(Vfs.lookup());
        quercus.setIni("caucho.server_id", Resin.getCurrent().getServerId());
    }

    protected WriteStream openWrite(HttpServletResponse response) throws IOException {
        WriteStream ws;
        if (response instanceof CauchoResponse) {
            ws = Vfs.openWrite(((CauchoResponse)response).getResponseStream());
        } else {
            ServletOutputStream out = response.getOutputStream();
            ws = Vfs.openWrite((OutputStream)out);
        }
        return ws;
    }

    protected QuercusContext getQuercus() {
        if (this._quercus == null) {
            this._quercus = new ResinQuercus();
        }
        return this._quercus;
    }
}

