/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng.pattern;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.pattern.NameClassPattern;
import com.caucho.relaxng.program.NameClassItem;
import com.caucho.relaxng.program.NsNameItem;

public class NsNamePattern
extends NameClassPattern {
    private String _name;
    private String _ns;
    private NameClassPattern _except;
    private NsNameItem _item;

    public NsNamePattern() {
    }

    public NsNamePattern(String ns) {
        this._ns = ns;
    }

    public NsNamePattern(String name, String ns) {
        this._name = name;
        this._ns = ns;
    }

    public void setNamespace(String ns) {
        this._ns = ns;
    }

    @Override
    public String getTagName() {
        return "nsName";
    }

    public void setExcept(NameClassPattern pattern) {
        this._except = pattern;
    }

    @Override
    public NameClassItem createNameItem() throws RelaxException {
        if (this._item == null) {
            NsNameItem item = new NsNameItem(this._ns);
            if (this._except != null) {
                item.setExcept(this._except.createNameItem());
            }
            this._item = item;
        }
        return this._item;
    }

    @Override
    public String toProduction() {
        if (this._except == null) {
            return this._ns + ":*";
        }
        return "(" + this._ns + ":* - " + this._except + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NsNamePattern)) {
            return false;
        }
        NsNamePattern pattern = (NsNamePattern)o;
        if (!this._ns.equals(pattern._ns)) {
            return false;
        }
        if (this._except == null) {
            return pattern._except == null;
        }
        return this._except.equals(pattern._except);
    }

    public String toString() {
        return "NsName[" + this._ns + "]";
    }
}

