/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.client;

import com.caucho.config.ConfigException;
import com.caucho.config.Configured;
import com.caucho.config.Names;
import com.caucho.config.cfg.BeanConfig;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.remote.client.ProtocolProxyFactory;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;

public class RemoteClient
extends BeanConfig {
    private static final L10N L = new L10N(RemoteClient.class);
    private Class<?> _interface;

    public RemoteClient() {
        this.setBeanConfigClass(ProtocolProxyFactory.class);
    }

    public void setInterface(Class<?> type) {
        this._interface = type;
        if (!type.isInterface()) {
            throw new ConfigException(L.l("remote-client interface '{0}' must be an interface", (Object)type.getName()));
        }
    }

    @Override
    protected void deploy() {
        this.deployBean(this._interface);
    }

    private <T> void deployBean(Class<T> iface) {
        ProtocolProxyFactory proxyFactory = (ProtocolProxyFactory)this.getObject();
        T proxy = proxyFactory.createProxy(iface);
        InjectManager beanManager = InjectManager.create();
        BeanBuilder<T> builder = beanManager.createBeanFactory(iface);
        if (this.getName() != null) {
            builder = builder.name(this.getName());
            this.addOptionalStringProperty("name", this.getName());
            builder.qualifier((Annotation)Names.create(this.getName()));
            if (this.getBindingList().size() == 0) {
                builder.qualifier((Annotation)DefaultLiteral.DEFAULT);
            }
        }
        for (Annotation binding : this.getBindingList()) {
            builder = builder.qualifier(binding);
        }
        for (Annotation stereotype : this.getStereotypeList()) {
            builder = builder.stereotype(stereotype.annotationType());
        }
        builder.stereotype(Configured.class);
        this._bean = builder.singleton(proxy);
        beanManager.addBeanDiscover(this._bean);
    }
}

