/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.server;

import com.caucho.config.ConfigException;
import com.caucho.remote.ServiceException;
import com.caucho.remote.server.ProtocolServletFactory;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Remote;
import javax.enterprise.inject.spi.Annotated;
import javax.jws.WebService;
import javax.servlet.Servlet;

public abstract class AbstractProtocolServletFactory
implements ProtocolServletFactory {
    private static final Logger log = Logger.getLogger(AbstractProtocolServletFactory.class.getName());
    private static Class<?> _webServiceClass;

    @Override
    public void setServiceType(Annotation ann) {
    }

    @Override
    public void setAnnotated(Annotated annotated) {
    }

    @Override
    public abstract Servlet createServlet(Class<?> var1, Object var2) throws ServiceException;

    protected Class<?> getRemoteAPI(Class<?> serviceClass) {
        Remote remote = serviceClass.getAnnotation(Remote.class);
        if (remote != null) {
            return remote.value()[0];
        }
        for (Class<?> ifc : serviceClass.getInterfaces()) {
            if (!ifc.isAnnotationPresent(Remote.class)) continue;
            return ifc;
        }
        Class<?> remoteAPI = null;
        if (_webServiceClass != null && (remoteAPI = this.getWebService(serviceClass)) != null) {
            return remoteAPI;
        }
        for (Class<?> ifc : serviceClass.getInterfaces()) {
            if (ifc.getName().startsWith("java.io") || ifc.getName().startsWith("javax.ejb")) continue;
            if (remoteAPI != null) {
                return serviceClass;
            }
            remoteAPI = ifc;
        }
        if (remoteAPI != null) {
            return remoteAPI;
        }
        return serviceClass;
    }

    private Class<?> getWebService(Class<?> serviceClass) {
        WebService webService = serviceClass.getAnnotation(WebService.class);
        if (webService != null && !"".equals(webService.endpointInterface())) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> api = Class.forName(webService.endpointInterface(), false, loader);
                return api;
            }
            catch (Exception e) {
                throw ConfigException.create(e);
            }
        }
        return null;
    }

    static {
        String webService = "javax.ws.WebService";
        Class<?> webServiceClass = null;
        try {
            webServiceClass = Class.forName(webService);
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        _webServiceClass = webServiceClass;
    }
}

