/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import java.io.IOException;
import java.io.InputStream;

public class MaskedInputStream
extends InputStream {
    private final byte[] _mask = new byte[4];
    private InputStream _is;
    private int _offset;

    public void init(InputStream is) {
        this._is = is;
    }

    public boolean readMask() throws IOException {
        InputStream is = this._is;
        byte[] mask = this._mask;
        mask[0] = (byte)is.read();
        mask[1] = (byte)is.read();
        mask[2] = (byte)is.read();
        int ch = is.read();
        mask[3] = (byte)ch;
        this._offset = 0;
        return ch >= 0;
    }

    @Override
    public int read() throws IOException {
        int ch = this._is.read();
        if (ch < 0) {
            return ch;
        }
        int offset = this._offset;
        this._offset = offset + 1 & 3;
        return (ch ^ this._mask[offset]) & 0xFF;
    }

    @Override
    public int available() throws IOException {
        return this._is.available();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._is + "]";
    }
}

