/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.remote.websocket;

import com.caucho.remote.websocket.WebSocketConstants;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.OutputStream;

public class WebSocketOutputStream
extends OutputStream
implements WebSocketConstants {
    private static final int BINARY_PASSTHROUGH_SIZE = 2048;
    private OutputStream _os;
    private byte[] _buffer;
    private int _offset;
    private MessageState _state = MessageState.IDLE;
    private boolean _isAutoFlush = true;

    public WebSocketOutputStream(OutputStream os, byte[] workingBuffer) throws IOException {
        if (os == null) {
            throw new NullPointerException();
        }
        if (workingBuffer == null) {
            throw new NullPointerException();
        }
        this._os = os;
        this._buffer = workingBuffer;
    }

    public WebSocketOutputStream(OutputStream os) throws IOException {
        this(os, TempBuffer.allocate().getBuffer());
    }

    public void setAutoFlush(boolean isAutoFlush) {
        this._isAutoFlush = isAutoFlush;
    }

    public void init() {
        if (this._state != MessageState.IDLE) {
            throw new IllegalStateException(String.valueOf((Object)this._state));
        }
        this._state = MessageState.FIRST;
        this._offset = 4;
    }

    @Override
    public void write(int ch) throws IOException {
        if (!this._state.isActive()) {
            throw new IllegalStateException(String.valueOf((Object)this._state));
        }
        byte[] buffer = this._buffer;
        if (this._offset == buffer.length) {
            this.complete(false);
        }
        buffer[this._offset++] = (byte)ch;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (!this._state.isActive()) {
            throw new IllegalStateException(String.valueOf((Object)this._state));
        }
        byte[] wsBuffer = this._buffer;
        if (length >= 2048) {
            this.complete(false);
            while (length > 0) {
                int sublen = Math.min(65535, length);
                int writeOffset = this.fillHeader(false, sublen + 4);
                this._os.write(wsBuffer, writeOffset, 4 - writeOffset);
                this._os.write(buffer, offset, sublen);
                offset += sublen;
                length -= sublen;
            }
            return;
        }
        while (length > 0) {
            int sublen;
            if (this._offset == wsBuffer.length) {
                this.complete(false);
            }
            if (length < (sublen = wsBuffer.length - this._offset)) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, wsBuffer, this._offset, sublen);
            offset += sublen;
            length -= sublen;
            this._offset += sublen;
        }
    }

    @Override
    public void flush() throws IOException {
        this.complete(false);
        this._os.flush();
    }

    @Override
    public void close() throws IOException {
        if (this._state == MessageState.IDLE) {
            return;
        }
        try {
            this.complete(true);
            if (this._isAutoFlush) {
                this._os.flush();
            }
        }
        finally {
            this._state = MessageState.IDLE;
        }
    }

    private void complete(boolean isFinal) throws IOException {
        byte[] buffer = this._buffer;
        int offset = this._offset;
        this._offset = 4;
        int writeOffset = this.fillHeader(isFinal, offset);
        if (writeOffset < 0) {
            return;
        }
        this._os.write(buffer, writeOffset, offset - writeOffset);
    }

    private int fillHeader(boolean isFinal, int tailOffset) throws IOException {
        byte[] buffer = this._buffer;
        if (tailOffset == 4 && !isFinal) {
            return -1;
        }
        int length = tailOffset - 4;
        int code1 = this._state == MessageState.FIRST ? 2 : 0;
        this._state = MessageState.CONT;
        if (isFinal) {
            code1 |= 0x80;
        }
        if (length < 126) {
            buffer[2] = (byte)code1;
            buffer[3] = (byte)length;
            return 2;
        }
        if (length <= 65535) {
            buffer[0] = (byte)code1;
            buffer[1] = 126;
            buffer[2] = (byte)(length >> 8);
            buffer[3] = (byte)length;
            return 0;
        }
        throw new IllegalStateException();
    }

    public void destroy() throws IOException {
        this._state = MessageState.DESTROYED;
    }

    static enum MessageState {
        IDLE,
        FIRST{

            @Override
            public boolean isActive() {
                return true;
            }
        }
        ,
        CONT{

            @Override
            public boolean isActive() {
                return true;
            }
        }
        ,
        DESTROYED;


        public boolean isActive() {
            return false;
        }
    }
}

