/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.util.L10N;
import javax.enterprise.context.ApplicationScoped;

public class BeanEmbed {
    private static final L10N L = new L10N(BeanEmbed.class);
    private Object _value;
    private String _className;
    private String _name;
    private ContainerProgram _init = new ContainerProgram();

    public BeanEmbed() {
    }

    public BeanEmbed(Object value) {
        this.setValue(value);
    }

    public BeanEmbed(Object value, String name) {
        this.setValue(value);
        this.setName(name);
    }

    public BeanEmbed(String className) {
        this.setClass(className);
    }

    public BeanEmbed(String className, String name) {
        this.setClass(className);
        this.setName(name);
    }

    public void setClass(String className) {
        this._className = className;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public void addProperty(String name, Object value) {
        this._init.addProgram(new PropertyValueProgram(name, value));
    }

    public void validate() {
        if (this._value != null) {
            return;
        }
    }

    protected void configure() {
        try {
            InjectManager cdiManager = InjectManager.create();
            if (this._value != null) {
                BeanBuilder<?> factory = cdiManager.createBeanFactory(this._value.getClass());
                if (this._name != null) {
                    factory.name(this._name);
                }
                cdiManager.addBeanDiscover(factory.singleton(this._value));
            } else {
                if (this._className == null) {
                    throw new ConfigException(L.l("BeanEmbed must either have a value or a class"));
                }
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName(this._className, false, loader);
                BeanBuilder<?> factory = cdiManager.createBeanFactory(cl);
                factory.scope(ApplicationScoped.class);
                if (this._name != null) {
                    factory.name(this._name);
                }
                if (this._init != null) {
                    factory.init(this._init);
                }
                cdiManager.addBeanDiscover(factory.bean());
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

