/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.cloud.network.NetworkListenSystem;
import com.caucho.config.ConfigException;
import com.caucho.env.service.ResinSystem;
import com.caucho.network.listen.TcpPort;
import com.caucho.resin.PortEmbed;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.http.HttpProtocol;
import com.caucho.vfs.JsseSSLFactory;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;

public class HttpsEmbed
extends PortEmbed {
    private TcpPort _port;
    private String _keyStoreType;
    private Path _keyStoreFile;
    private String _alias;
    private String _password;

    public HttpsEmbed() {
    }

    public HttpsEmbed(int port) {
        this.setPort(port);
    }

    public HttpsEmbed(int port, String ipAddress) {
        this.setPort(port);
        this.setAddress(ipAddress);
    }

    @Override
    public int getLocalPort() {
        if (this._port != null) {
            return this._port.getLocalPort();
        }
        return this.getPort();
    }

    public HttpsEmbed setKeyStoreFile(String path) {
        this._keyStoreFile = Vfs.lookup(path);
        return this;
    }

    public HttpsEmbed setAlias(String alias) {
        this._alias = alias;
        return this;
    }

    public HttpsEmbed setPassword(String password) {
        this._password = password;
        return this;
    }

    public HttpsEmbed setKeyStoreType(String keyStoreType) {
        this._keyStoreType = keyStoreType;
        return this;
    }

    @Override
    public void bindTo(ServletService server) {
        try {
            this._port = new TcpPort();
            this._port.setProtocol(new HttpProtocol());
            this._port.setPort(this.getPort());
            this._port.setAddress(this.getAddress());
            JsseSSLFactory jsse = this._port.createJsse();
            jsse.setKeyStoreFile(this._keyStoreFile);
            if (this._keyStoreType != null) {
                jsse.setKeyStoreType(this._keyStoreType);
            }
            jsse.setAlias(this._alias);
            jsse.setPassword(this._password);
            jsse.init();
            this._port.setJsseSsl(jsse);
            this._port.init();
            ResinSystem system = server.getResinSystem();
            NetworkListenSystem listenService = system.getService(NetworkListenSystem.class);
            listenService.addListener(this._port);
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }
}

