/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.rewrite.RequestPredicate;
import com.caucho.rewrite.RewriteFilter;
import com.caucho.rewrite.RewriteFilterAdapter;
import com.caucho.server.rewrite.MatchFilterChain;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;

public abstract class AbstractRewriteFilter
implements RewriteFilter {
    private Pattern _regexp;
    private ArrayList<RequestPredicate> _predicateList = new ArrayList();
    private RequestPredicate[] _predicates = new RequestPredicate[0];
    private ArrayList<RewriteFilter> _filterList = new ArrayList();
    private RewriteFilter[] _filters = new RewriteFilter[0];

    public void setRegexp(Pattern regexp) {
        this._regexp = regexp;
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    @Override
    public boolean isInclude() {
        return false;
    }

    @Override
    public boolean isForward() {
        return false;
    }

    public void add(RequestPredicate predicate) {
        this._predicateList.add(predicate);
        this._predicates = new RequestPredicate[this._predicateList.size()];
        this._predicateList.toArray(this._predicates);
    }

    public void add(RewriteFilter filter) {
        this._filterList.add(filter);
        this._filters = new RewriteFilter[this._filterList.size()];
        this._filterList.toArray(this._filters);
    }

    public void add(Filter filter) throws ServletException {
        this.add(new RewriteFilterAdapter(filter));
    }

    @Override
    public FilterChain map(String uri, String queryString, FilterChain next) throws ServletException {
        if (this._regexp == null || this._regexp.matcher(uri).find()) {
            FilterChain chain = this.createFilterChain(uri, queryString, next);
            for (int i = this._filters.length - 1; i >= 0; --i) {
                chain = this._filters[i].map(uri, queryString, chain);
            }
            if (this._predicates.length > 0) {
                chain = new MatchFilterChain(this._predicates, chain, next);
            }
            return chain;
        }
        return next;
    }

    protected FilterChain createFilterChain(String uri, String queryString, FilterChain next) {
        return next;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[regexp=" + this._regexp + "]";
    }
}

