/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.rewrite.RequestPredicate;
import com.caucho.util.L10N;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

@Configurable
public class IfCookie
implements RequestPredicate {
    private static final L10N L = new L10N(IfCookie.class);
    private String _name;
    private Pattern _regexp;

    @Configurable
    public void setName(String name) {
        this._name = name;
    }

    @Configurable
    public void setRegexp(Pattern regexp) {
        this._regexp = regexp;
    }

    public void setValue(Pattern regexp) {
        this.setRegexp(regexp);
    }

    @PostConstruct
    public void init() {
        if (this._name == null) {
            throw new ConfigException(L.l("'name' is a required attribute for {0}", (Object)this.getClass().getSimpleName()));
        }
    }

    @Override
    public boolean isMatch(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookie.getName().equals(this._name)) continue;
                return this._regexp == null || this._regexp.matcher(cookie.getValue()).find();
            }
        }
        return false;
    }
}

