/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.server.session.SessionImpl;
import java.lang.ref.SoftReference;
import java.security.Principal;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;

public class SingleSignonEntry {
    private static final Logger log = Logger.getLogger(SingleSignonEntry.class.getName());
    private Principal _principal;
    private ArrayList<SoftReference<SessionImpl>> _sessions;

    SingleSignonEntry(Principal principal) {
        this._principal = principal;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    protected void addSession(SessionImpl session) {
        if (this._sessions == null) {
            this._sessions = new ArrayList();
        }
        this._sessions.add(new SoftReference<SessionImpl>(session));
    }

    protected boolean logoutSession(HttpSession timeoutSession) {
        ArrayList<SoftReference<SessionImpl>> sessions = this._sessions;
        if (sessions == null) {
            return true;
        }
        boolean isEmpty = true;
        for (int i = sessions.size() - 1; i >= 0; --i) {
            SoftReference<SessionImpl> ref = sessions.get(i);
            SessionImpl session = ref.get();
            try {
                if (session == timeoutSession) {
                    sessions.remove(i);
                    continue;
                }
                if (session == null) {
                    sessions.remove(i);
                    continue;
                }
                isEmpty = false;
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        return isEmpty;
    }

    protected void logout() {
        ArrayList<SoftReference<SessionImpl>> sessions = this._sessions;
        this._sessions = null;
        for (int i = 0; sessions != null && i < sessions.size(); ++i) {
            SoftReference<SessionImpl> ref = sessions.get(i);
            SessionImpl session = ref.get();
            try {
                if (session == null) continue;
                session.invalidateLogout();
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

