/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.bam.actor.RemoteActorSender;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class HmuxClientFactory {
    private String _address;
    private int _port;
    private String _userName;
    private String _password;

    public HmuxClientFactory(String address, int port, String userName, String password) {
        this._address = address;
        this._port = port;
        this._userName = userName;
        this._password = password;
    }

    public RemoteActorSender create() {
        RemoteActorSender sender;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> hmuxClientClass = Class.forName("com.caucho.server.cluster.HmuxClient", false, loader);
            Constructor<?> ctor = hmuxClientClass.getConstructor(String.class, Integer.TYPE, String.class, String.class);
            sender = (RemoteActorSender)ctor.newInstance(this._address, this._port, this._userName, this._password);
        }
        catch (ClassNotFoundException e) {
            sender = null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sender;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._address + ":" + this._port + "]";
    }
}

