/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.admin.action.AddLicenseAction;
import com.caucho.admin.action.AddUserAction;
import com.caucho.admin.action.CallJmxAction;
import com.caucho.admin.action.GetStatsAction;
import com.caucho.admin.action.HeapDumpAction;
import com.caucho.admin.action.JmxDumpAction;
import com.caucho.admin.action.ListJmxAction;
import com.caucho.admin.action.ListUsersAction;
import com.caucho.admin.action.PdfReportAction;
import com.caucho.admin.action.ProfileAction;
import com.caucho.admin.action.RemoveUserAction;
import com.caucho.admin.action.ScoreboardAction;
import com.caucho.admin.action.SetJmxAction;
import com.caucho.admin.action.SetLogLevelAction;
import com.caucho.admin.action.ThreadDumpAction;
import com.caucho.bam.Query;
import com.caucho.bam.actor.SimpleActor;
import com.caucho.bam.mailbox.MultiworkerMailbox;
import com.caucho.cloud.bam.BamSystem;
import com.caucho.cloud.network.NetworkClusterSystem;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.ConfigException;
import com.caucho.env.service.ResinSystem;
import com.caucho.security.AdminAuthenticator;
import com.caucho.security.PasswordUser;
import com.caucho.server.admin.AddUserQuery;
import com.caucho.server.admin.AddUserQueryReply;
import com.caucho.server.admin.HeapDumpQuery;
import com.caucho.server.admin.JmxCallQuery;
import com.caucho.server.admin.JmxCallQueryReply;
import com.caucho.server.admin.JmxDumpQuery;
import com.caucho.server.admin.JmxListQuery;
import com.caucho.server.admin.JmxSetQuery;
import com.caucho.server.admin.JmxSetQueryReply;
import com.caucho.server.admin.JsonQueryReply;
import com.caucho.server.admin.LicenseAddQuery;
import com.caucho.server.admin.ListJmxQueryReply;
import com.caucho.server.admin.ListRestartsQuery;
import com.caucho.server.admin.ListUsersQuery;
import com.caucho.server.admin.ListUsersQueryReply;
import com.caucho.server.admin.LogLevelQuery;
import com.caucho.server.admin.PdfReportQuery;
import com.caucho.server.admin.PdfReportQueryReply;
import com.caucho.server.admin.ProfileQuery;
import com.caucho.server.admin.RemoveUserQuery;
import com.caucho.server.admin.RemoveUserQueryReply;
import com.caucho.server.admin.ScoreboardQuery;
import com.caucho.server.admin.ServerStatusQuery;
import com.caucho.server.admin.ServerStatusWebAppQuery;
import com.caucho.server.admin.StatServiceValuesQueryReply;
import com.caucho.server.admin.StatSystem;
import com.caucho.server.admin.StatsQuery;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.server.admin.ThreadDumpQuery;
import com.caucho.server.admin.UserQueryReply;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.cluster.ServletSystem;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostController;
import com.caucho.server.resin.Resin;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.management.JMException;

public class ManagerActor
extends SimpleActor {
    private static final Logger log = Logger.getLogger(ManagerActor.class.getName());
    private static final L10N L = new L10N(ManagerActor.class);
    private ServletService _server;
    private Path _hprofDir;
    private AtomicBoolean _isInit = new AtomicBoolean();
    private AdminAuthenticator _adminAuthenticator;

    public ManagerActor() {
        super("manager@resin.caucho", BamSystem.getCurrentBroker());
    }

    @PostConstruct
    public void init() {
        if (this._isInit.getAndSet(true)) {
            return;
        }
        this._server = ServletService.getCurrent();
        if (this._server == null) {
            throw new ConfigException(L.l("resin:ManagerService requires an active Server.\n  {0}", (Object)Thread.currentThread().getContextClassLoader()));
        }
        this._adminAuthenticator = this._server.getAdminAuthenticator();
        String address = this.getActor().getAddress();
        this.setBroker(this.getBroker());
        MultiworkerMailbox mailbox = new MultiworkerMailbox(address, this.getActor(), this.getBroker(), 2);
        this.getBroker().addMailbox(address, mailbox);
    }

    public Path getHprofDir() {
        return this._hprofDir;
    }

    public void setHprofDir(String hprofDir) {
        Path path;
        if (hprofDir.isEmpty()) {
            throw new ConfigException("hprof-dir can not be set to an emtpy string");
        }
        this._hprofDir = path = Vfs.lookup(hprofDir);
    }

    @Query
    public AddUserQueryReply addUser(long id, String to, String from, AddUserQuery query) {
        PasswordUser user = new AddUserAction(this._adminAuthenticator, query.getUser(), query.getPassword(), query.getRoles()).execute();
        AddUserQueryReply result = new AddUserQueryReply(new UserQueryReply.User(user.getPrincipal().getName(), user.getRoles()));
        this.getBroker().queryResult(id, from, to, result);
        return result;
    }

    @Query
    public ListUsersQueryReply listUsers(long id, String to, String from, ListUsersQuery query) {
        Hashtable<String, PasswordUser> userMap = new ListUsersAction(this._adminAuthenticator).execute();
        ArrayList<UserQueryReply.User> userList = new ArrayList<UserQueryReply.User>();
        for (Map.Entry<String, PasswordUser> userEntry : userMap.entrySet()) {
            PasswordUser passwordUser = userEntry.getValue();
            UserQueryReply.User user = new UserQueryReply.User(userEntry.getKey(), passwordUser.getRoles());
            userList.add(user);
        }
        UserQueryReply.User[] users = userList.toArray(new UserQueryReply.User[userList.size()]);
        ListUsersQueryReply result = new ListUsersQueryReply(users);
        this.getBroker().queryResult(id, from, to, result);
        return result;
    }

    @Query
    public RemoveUserQueryReply removeUser(long id, String to, String from, RemoveUserQuery query) {
        PasswordUser user = new RemoveUserAction(this._adminAuthenticator, query.getUser()).execute();
        RemoveUserQueryReply result = new RemoveUserQueryReply(new UserQueryReply.User(user.getPrincipal().getName(), user.getRoles()));
        this.getBroker().queryResult(id, from, to, result);
        return result;
    }

    @Query
    public StringQueryReply doThreadDump(long id, String to, String from, ThreadDumpQuery query) {
        StringQueryReply reply = query.isJson() ? new JsonQueryReply(new ThreadDumpAction().executeJson()) : new StringQueryReply(new ThreadDumpAction().execute(32, false));
        this.getBroker().queryResult(id, from, to, reply);
        return reply;
    }

    @Query
    public StringQueryReply doHeapDump(long id, String to, String from, HeapDumpQuery query) {
        try {
            String dump = new HeapDumpAction().execute(query.isRaw(), this._server.getServerId(), this._hprofDir);
            StringQueryReply result = new StringQueryReply(dump);
            this.getBroker().queryResult(id, from, to, result);
            return result;
        }
        catch (JMException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Query
    public ListJmxQueryReply listJmx(long id, String to, String from, JmxListQuery query) {
        try {
            ListJmxQueryReply result = new ListJmxAction().execute(query.getPattern(), query.isPrintAttributes(), query.isPrintValues(), query.isPrintOperations(), query.isAllBeans(), query.isPlatform());
            this.getBroker().queryResult(id, from, to, result);
            return result;
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Query
    public JsonQueryReply doJmxDump(long id, String to, String from, JmxDumpQuery query) {
        try {
            String jmxDump = new JmxDumpAction().execute();
            JsonQueryReply result = new JsonQueryReply(jmxDump);
            this.getBroker().queryResult(id, from, to, result);
            return result;
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Query
    public JmxSetQueryReply setJmx(long id, String to, String from, JmxSetQuery query) {
        try {
            JmxSetQueryReply result = new SetJmxAction().execute(query.getPattern(), query.getAttribute(), query.getValue());
            this.getBroker().queryResult(id, from, to, result);
            return result;
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Query
    public JmxCallQueryReply callJmx(long id, String to, String from, JmxCallQuery query) {
        try {
            JmxCallQueryReply reply = new CallJmxAction().execute(query.getPattern(), query.getOperation(), query.getOperationIndex(), query.getParams());
            this.getBroker().queryResult(id, from, to, reply);
            return reply;
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Query
    public StringQueryReply setLogLevel(long id, String to, String from, LogLevelQuery query) {
        String message = new SetLogLevelAction().execute(query.getLoggers(), query.getLevel(), query.getPeriod());
        StringQueryReply result = new StringQueryReply(message);
        this.getBroker().queryResult(id, from, to, result);
        return result;
    }

    @Query
    Serializable getStats(long id, String to, String from, StatsQuery query) {
        GetStatsAction action = new GetStatsAction();
        StatServiceValuesQueryReply result = action.execute(query.getMeters(), query.getFrom(), query.getTo());
        this.getBroker().queryResult(id, from, to, result);
        return result;
    }

    @Query
    public PdfReportQueryReply pdfReport(long id, String to, String from, PdfReportQuery query) {
        PdfReportAction action = new PdfReportAction();
        if (query.getPath() != null) {
            action.setPath(query.getPath());
        }
        if (query.getPeriod() > 0L) {
            action.setPeriod(query.getPeriod());
        }
        action.setSnapshot(query.isSnapshot());
        action.setWatchdog(query.isWatchdog());
        if (query.getProfileTime() > 0L) {
            action.setProfileTime(query.getProfileTime());
        }
        if (query.getSamplePeriod() > 0L) {
            action.setProfileTick(query.getSamplePeriod());
        }
        if (query.getServerId() != null) {
            action.setServerId(query.getServerId());
        }
        if (query.getReport() != null) {
            action.setReport(query.getReport());
        }
        if (query.getLogDirectory() != null) {
            action.setLogDirectory(query.getLogDirectory());
        }
        action.setReturnPdf(query.isReturnPdf());
        try {
            action.init();
            PdfReportAction.PdfReportActionResult actionResult = action.execute();
            StreamSource pdfSource = null;
            if (query.isReturnPdf()) {
                pdfSource = new StreamSource(actionResult.getPdfOutputStream());
            }
            PdfReportQueryReply result = new PdfReportQueryReply(actionResult.getMessage(), actionResult.getFileName(), pdfSource);
            this.getBroker().queryResult(id, from, to, result);
            return result;
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    @Query
    public StringQueryReply profile(long id, String to, String from, ProfileQuery query) {
        String profile = new ProfileAction().execute(query.getActiveTime(), query.getPeriod(), query.getDepth());
        StringQueryReply result = new StringQueryReply(profile);
        this.getBroker().queryResult(id, from, to, result);
        return result;
    }

    @Query
    public Date[] listRestarts(long id, String to, String from, ListRestartsQuery query) {
        long now = CurrentTime.getCurrentTime();
        NetworkClusterSystem clusterService = NetworkClusterSystem.getCurrent();
        CloudServer cloudServer = clusterService.getSelfServer();
        int index = cloudServer.getIndex();
        StatSystem statSystem = ResinSystem.getCurrentService(StatSystem.class);
        if (statSystem == null) {
            throw new IllegalStateException("StatSystem is not active");
        }
        long[] restartTimes = statSystem.getStartTimes(index, now - query.getTimeBackSpan(), now);
        ArrayList<Date> restartsList = new ArrayList<Date>();
        for (long restartTime : restartTimes) {
            restartsList.add(new Date(restartTime));
        }
        Date[] restarts = new Date[restartsList.size()];
        restartsList.toArray(restarts);
        this.getBroker().queryResult(id, from, to, (Serializable)restarts);
        return restarts;
    }

    @Query
    public StringQueryReply addLicense(long id, String to, String from, LicenseAddQuery query) {
        String message = new AddLicenseAction().execute(query.getLicenseContent(), query.getFileName(), query.isOverwrite(), query.isRestart());
        StringQueryReply result = new StringQueryReply(message);
        this.getBroker().queryResult(id, from, to, result);
        return result;
    }

    @Query
    public StringQueryReply status(long id, String to, String from, ServerStatusQuery query) {
        Resin resin = Resin.getCurrent();
        CloudServer cloudServer = resin.getSelfServer();
        String status = L.l("Server {0} : {1}", (Object)cloudServer, (Object)cloudServer.getState());
        StringQueryReply reply = new StringQueryReply(status);
        this.getBroker().queryResult(id, from, to, reply);
        return reply;
    }

    @Query
    public StringQueryReply statusWebApp(long id, String to, String from, ServerStatusWebAppQuery query) {
        Resin resin = Resin.getCurrent();
        CloudServer cloudServer = resin.getSelfServer();
        ServletSystem system = ServletSystem.getCurrent();
        if (system == null) {
            return null;
        }
        ServletService server = system.getServer();
        if (server == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (HostController hostCtrl : server.getHostControllers()) {
            Host host = (Host)hostCtrl.getDeployInstance();
            if (host == null) continue;
            for (WebAppController webAppCtrl : host.getWebAppContainer().getWebAppList()) {
                sb.append("web-app '").append(webAppCtrl.getIdKey()).append("': ");
                sb.append(webAppCtrl.getState().toString());
                sb.append("\n");
            }
        }
        String status = sb.toString();
        StringQueryReply reply = new StringQueryReply(status);
        this.getBroker().queryResult(id, from, to, reply);
        return reply;
    }

    @Query
    public StringQueryReply scoreboard(long id, String to, String from, ScoreboardQuery query) {
        String message = new ScoreboardAction().excute(query.getType(), query.isGreedy());
        StringQueryReply result = new StringQueryReply(message);
        this.getBroker().queryResult(id, from, to, result);
        return result;
    }
}

