/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.dispatch.FilterConfigImpl;
import com.caucho.server.dispatch.FilterMapping;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

public class FilterManager {
    static final Logger log = Logger.getLogger(FilterManager.class.getName());
    static final L10N L = new L10N(FilterManager.class);
    private HashMap<String, FilterConfigImpl> _filters = new HashMap();
    private InjectionTarget _bean;
    private HashMap<String, Filter> _instances = new HashMap();
    private Map<String, Set<String>> _urlPatterns = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> _servletNames = new HashMap<String, Set<String>>();

    public void addFilter(FilterConfigImpl config) {
        if (config.getServletContext() == null) {
            throw new NullPointerException();
        }
        this._filters.put(config.getFilterName(), config);
    }

    public FilterConfigImpl getFilter(String filterName) {
        return this._filters.get(filterName);
    }

    public HashMap<String, FilterConfigImpl> getFilters() {
        return this._filters;
    }

    @PostConstruct
    public void init() {
        for (String name : this._filters.keySet()) {
            try {
                this.createFilter(name);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public void addFilterMapping(FilterMapping filterMapping) {
        ArrayList<String> servletNames;
        HashSet<String> patterns = filterMapping.getURLPatterns();
        if (patterns != null) {
            Set<String> urls = this._urlPatterns.get(filterMapping.getName());
            if (urls == null) {
                urls = new LinkedHashSet<String>();
                this._urlPatterns.put(filterMapping.getName(), urls);
            }
            urls.addAll(patterns);
        }
        if ((servletNames = filterMapping.getServletNames()) != null && servletNames.size() > 0) {
            Set<String> names = this._servletNames.get(filterMapping.getName());
            if (names == null) {
                names = new HashSet<String>();
                this._servletNames.put(filterMapping.getName(), names);
            }
            names.addAll(servletNames);
        }
    }

    public Set<String> getUrlPatternMappings(String filterName) {
        return this._urlPatterns.get(filterName);
    }

    public Set<String> getServletNameMappings(String filterName) {
        return this._servletNames.get(filterName);
    }

    public Filter createFilter(String filterName) throws ServletException {
        FilterConfigImpl config = this._filters.get(filterName);
        if (config == null) {
            throw new ServletException(L.l("`{0}' is not a known filter.  Filters must be defined by <filter> before being used.", (Object)filterName));
        }
        Class<?> filterClass = config.getFilterClass();
        FilterConfigImpl filterConfigImpl = config;
        synchronized (filterConfigImpl) {
            try {
                Filter filter = this._instances.get(filterName);
                if (filter != null) {
                    return filter;
                }
                InjectManager beanManager = InjectManager.create();
                this._bean = beanManager.discoverInjectionTarget(filterClass);
                filter = config.getFilter();
                CreationalContext env = beanManager.createCreationalContext(null);
                if (filter == null) {
                    filter = (Filter)this._bean.produce(env);
                }
                this._bean.inject((Object)filter, env);
                ContainerProgram init = config.getInit();
                if (init != null) {
                    init.configure(filter);
                }
                this._bean.postConstruct((Object)filter);
                filter.init((FilterConfig)config);
                this._instances.put(filterName, filter);
                return filter;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ServletException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (this._instances != null) {
            HashMap<String, Filter> hashMap = this._instances;
            synchronized (hashMap) {
                for (Filter filter : this._instances.values()) {
                    filterList.add(filter);
                }
            }
        }
        for (int i = 0; i < filterList.size(); ++i) {
            Filter filter = (Filter)filterList.get(i);
            try {
                if (this._bean != null) {
                    this._bean.preDestroy((Object)filter);
                }
                filter.destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }
}

