/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationBuilder;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.dispatch.InvocationMatcher;
import com.caucho.server.dispatch.ServerListener;
import com.caucho.util.LruCache;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class InvocationServer
implements Dependency {
    private String _serverId = "";
    private InvocationBuilder _invocationBuilder;
    private LruCache<Object, Invocation> _invocationCache;
    private InvocationDecoder _invocationDecoder;
    private ArrayList<ServerListener> _listeners = new ArrayList();
    private int _invocationCacheSize = 65536;
    private int _maxURLLength = 256;
    private int _maxURILength = 1024;
    private final Lifecycle _lifecycle = new Lifecycle();

    public InvocationServer(InvocationBuilder builder) {
        this._invocationBuilder = builder;
        if (builder == null) {
            throw new NullPointerException();
        }
    }

    public String getServerId() {
        return this._serverId;
    }

    public void setServerId(String serverId) {
        this._serverId = serverId;
    }

    public InvocationBuilder getInvocationBuilder() {
        return this._invocationBuilder;
    }

    public void setInvocationCacheSize(int size) {
        this._invocationCacheSize = Math.max(size, 16);
    }

    public int getInvocationCacheSize() {
        return this._invocationCacheSize;
    }

    public void setInvocationCacheMaxURLLength(int length) {
        this._maxURLLength = length;
    }

    public int getMaxURILength() {
        return this._maxURILength;
    }

    public void setMaxURILength(int maxURILength) {
        this._maxURILength = maxURILength;
    }

    @PostConstruct
    public void init() {
        this._invocationCache = new LruCache(this._invocationCacheSize);
        this._invocationCache.setEnableStatistics(true);
    }

    public InvocationDecoder getInvocationDecoder() {
        if (this._invocationDecoder == null) {
            this._invocationDecoder = new InvocationDecoder();
            this._invocationDecoder.setMaxURILength(this._maxURILength);
        }
        return this._invocationDecoder;
    }

    public String getURLCharacterEncoding() {
        return this.getInvocationDecoder().getEncoding();
    }

    public InvocationDecoder createInvocationDecoder() {
        return this.getInvocationDecoder();
    }

    public final Invocation getInvocation(Object protocolKey) {
        Invocation invocation = null;
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            invocation = invocationCache.get(protocolKey);
        }
        if (invocation == null) {
            return null;
        }
        if (invocation.isModified()) {
            return null;
        }
        return invocation;
    }

    public Invocation createInvocation() {
        return new Invocation();
    }

    public Invocation buildInvocation(Object protocolKey, Invocation invocation) throws ConfigException {
        invocation = this.buildInvocation(invocation);
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            Invocation oldInvocation = invocationCache.get(protocolKey);
            if (oldInvocation != null && !oldInvocation.isModified()) {
                return oldInvocation;
            }
            if (invocation.getURLLength() < this._maxURLLength) {
                invocationCache.put(protocolKey, invocation);
            }
        }
        return invocation;
    }

    public Invocation buildInvocation(Invocation invocation) throws ConfigException {
        return this.getInvocationBuilder().buildInvocation(invocation);
    }

    public void clearCache() {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            invocationCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateMatchingInvocations(InvocationMatcher matcher) {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            LruCache<Object, Invocation> lruCache = invocationCache;
            synchronized (lruCache) {
                Iterator<LruCache.Entry<Object, Invocation>> iter = invocationCache.iterator();
                while (iter.hasNext()) {
                    LruCache.Entry<Object, Invocation> entry = iter.next();
                    Invocation value = entry.getValue();
                    if (value == null || !matcher.isMatch(value)) continue;
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Invocation> getInvocations() {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            ArrayList<Invocation> invocationList = new ArrayList<Invocation>();
            LruCache<Object, Invocation> lruCache = invocationCache;
            synchronized (lruCache) {
                Iterator<Invocation> iter = invocationCache.values();
                while (iter.hasNext()) {
                    invocationList.add(iter.next());
                }
            }
            return invocationList;
        }
        return null;
    }

    public long getInvocationCacheHitCount() {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            return invocationCache.getHitCount();
        }
        return 0L;
    }

    public long getInvocationCacheMissCount() {
        LruCache<Object, Invocation> invocationCache = this._invocationCache;
        if (invocationCache != null) {
            return invocationCache.getMissCount();
        }
        return 0L;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean logModified(Logger log) {
        return false;
    }

    public void addServerListener(ServerListener listener) {
        this._listeners.add(listener);
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public void destroy() {
        ArrayList<ServerListener> listeners = new ArrayList<ServerListener>(this._listeners);
        this._listeners.clear();
        for (int i = 0; i < listeners.size(); ++i) {
            ServerListener listener = listeners.get(i);
            listener.closeEvent(this);
        }
        this._invocationCache = null;
    }
}

