/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.host.Host;
import com.caucho.server.webapp.WebApp;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedirectSecureFilterChain
implements FilterChain {
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String queryString;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        WebApp webApp = (WebApp)req.getServletContext();
        String path = req.getContextPath();
        String servletPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        if (servletPath != null) {
            path = path + servletPath;
        }
        if (pathInfo != null) {
            path = path + pathInfo;
        }
        if ((queryString = req.getQueryString()) != null) {
            path = path + "?" + queryString;
        }
        Host host = webApp.getHost();
        String secureHostName = req.getServerName();
        if (host != null && host.getSecureHostName() != null) {
            secureHostName = host.getSecureHostName();
        }
        res.sendRedirect(res.encodeURL("https://" + secureHostName + path));
    }
}

