/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.dispatch.ServletConfigImpl;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

public class SingleThreadServletFilterChain
implements FilterChain {
    private ServletConfigImpl _config;
    private Servlet _servlet;

    public SingleThreadServletFilterChain(ServletConfigImpl config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this._config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Servlet servlet = null;
        SingleThreadServletFilterChain singleThreadServletFilterChain = this;
        synchronized (singleThreadServletFilterChain) {
            servlet = this._servlet;
            this._servlet = null;
        }
        if (servlet == null) {
            try {
                servlet = (Servlet)this._config.createServletMulti();
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        try {
            servlet.service(request, response);
        }
        catch (UnavailableException e) {
            this._config.setInitException((ServletException)((Object)e));
            throw e;
        }
        singleThreadServletFilterChain = this;
        synchronized (singleThreadServletFilterChain) {
            if (this._servlet == null) {
                this._servlet = servlet;
                servlet = null;
            }
        }
        if (servlet != null) {
            servlet.destroy();
        }
    }
}

