/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.cache.Cache;
import com.caucho.cache.CacheLoader;
import com.caucho.server.distcache.CacheLoaderCallback;
import com.caucho.server.distcache.CacheLoaderExt;
import com.caucho.server.distcache.DistCacheEntry;
import java.util.Map;

public class CacheLoaderAdapter<K, V>
implements CacheLoaderExt<K, V> {
    private final CacheLoader<K, V> _loader;

    public CacheLoaderAdapter(CacheLoader<K, V> loader) {
        this._loader = loader;
    }

    @Override
    public void load(DistCacheEntry entry, CacheLoaderCallback cb) {
        Cache.Entry loadedEntry = this._loader.load(entry.getKey());
        if (loadedEntry != null) {
            cb.onLoad(entry, loadedEntry.getValue());
        } else {
            cb.onLoad(entry, null);
        }
    }

    public Cache.Entry<K, V> load(Object key) {
        return this._loader.load(key);
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) {
        return this._loader.loadAll(keys);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._loader + "]";
    }
}

