/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.inject.Module;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheHandle;
import com.caucho.util.HashKey;
import java.util.concurrent.ConcurrentHashMap;

@Module
final class CacheRegionManager {
    private final ConcurrentHashMap<HashKey, CacheHandle> _regionCache = new ConcurrentHashMap();

    CacheRegionManager() {
    }

    public CacheHandle getCache(HashKey key) {
        if (key == null) {
            return null;
        }
        return this._regionCache.get(key);
    }

    public CacheHandle createCache(HashKey key, CacheConfig config) {
        if (key == null) {
            throw new NullPointerException();
        }
        CacheHandle cache = this._regionCache.get(key);
        if (cache == null) {
            cache = new CacheHandle(key, config);
            cache.setConfig(config);
            this._regionCache.putIfAbsent(key, cache);
            cache = this._regionCache.get(key);
        }
        return cache;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

