/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.fastcgi;

import com.caucho.server.fastcgi.FastCgiRequest;
import com.caucho.server.fastcgi.FastCgiResponseStream;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.AbstractHttpResponse;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.Cookie;

public class FastCgiResponse
extends AbstractHttpResponse {
    private final FastCgiRequest _req;
    private final CharBuffer _cb = new CharBuffer();

    FastCgiResponse(FastCgiRequest request, WriteStream rawWrite) {
        super(request);
        this._req = request;
        if (request == null) {
            throw new NullPointerException();
        }
    }

    @Override
    protected AbstractResponseStream createResponseStream() {
        FastCgiRequest request = (FastCgiRequest)this.getRequest();
        return new FastCgiResponseStream(request, this, request.getWriteStream());
    }

    @Override
    public void setHeaderWritten(boolean isWritten) {
    }

    @Override
    protected boolean writeHeadersInt(int length, boolean isHead) throws IOException {
        AbstractHttpRequest request = this.getRequest();
        if (!request.hasRequest()) {
            return false;
        }
        HttpServletResponseImpl response = request.getResponseFacade();
        int statusCode = response.getStatus();
        String statusMessage = response.getStatusMessage();
        WriteStream os = this._req.getWriteStream();
        os.print("Status: ");
        os.print(statusCode);
        os.print(' ');
        os.print(statusMessage);
        os.print("\r\n");
        CharBuffer cb = this._cb;
        if (statusCode >= 400) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
        } else if (response.isNoCache()) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            os.print("Cache-Control: no-cache\r\n");
        } else if (response.isPrivateCache()) {
            os.print("Cache-Control: private\r\n");
        }
        String serverHeader = this.getServerHeader();
        if (serverHeader != null) {
            os.print("Server: ");
            os.printLatin1NoLf(serverHeader);
            os.print("\r\n");
        }
        ArrayList<String> headerKeys = this.getHeaderKeys();
        ArrayList<String> headerValues = this.getHeaderValues();
        int size = headerKeys.size();
        for (int i = 0; i < size; ++i) {
            String key = headerKeys.get(i);
            String value = headerValues.get(i);
            os.print(key);
            os.print(": ");
            os.print(value);
            os.print("\r\n");
        }
        long now = CurrentTime.getCurrentTime();
        ArrayList<Cookie> cookiesOut = response.getCookies();
        if (cookiesOut != null) {
            size = cookiesOut.size();
            for (int i = 0; i < size; ++i) {
                Cookie cookie = cookiesOut.get(i);
                int cookieVersion = cookie.getVersion();
                cb.clear();
                this.fillCookie(cb, cookie, now, 0, false);
                os.print("Set-Cookie: ");
                os.print(cb);
                os.print("\r\n");
                if (cookieVersion <= 0) continue;
                cb.clear();
                this.fillCookie(cb, cookie, now, cookieVersion, true);
                os.print("Set-Cookie2: ");
                os.print(cb);
                os.print("\r\n");
            }
        }
        String contentType = response.getContentTypeImpl();
        String charEncoding = response.getCharacterEncodingImpl();
        if (contentType != null) {
            if (charEncoding != null) {
                os.print("Content-Type: ");
                os.print(contentType);
                os.print("; charset=");
                os.print(charEncoding);
                os.print("\r\n");
            } else {
                os.print("Content-Type: ");
                os.print(contentType);
                os.print("\r\n");
            }
        }
        os.print("\r\n");
        return false;
    }
}

