/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.VersionFactory;
import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.hmux.HmuxRequest;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostController;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.Crc64;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmuxDispatchRequest {
    private static final Logger log = Logger.getLogger(HmuxDispatchRequest.class.getName());
    public static final int HMUX_HOST = 104;
    public static final int HMUX_QUERY_ALL = 113;
    public static final int HMUX_QUERY_URL = 114;
    public static final int HMUX_QUERY_SERVER = 115;
    public static final int HMUX_WEB_APP = 97;
    public static final int HMUX_MATCH = 109;
    public static final int HMUX_IGNORE = 105;
    public static final int HMUX_ETAG = 101;
    public static final int HMUX_NO_CHANGE = 110;
    public static final int HMUX_CLUSTER = 99;
    public static final int HMUX_SRUN = 115;
    public static final int HMUX_SRUN_BACKUP = 98;
    public static final int HMUX_SRUN_SSL = 101;
    public static final int HMUX_UNAVAILABLE = 117;
    public static final int HMUX_WEB_APP_UNAVAILABLE = 85;
    private CharBuffer _cb = new CharBuffer();
    private HmuxRequest _request;
    private ServletService _server;

    public HmuxDispatchRequest(HmuxRequest request) {
        this._request = request;
        this._server = request.getServer();
    }

    public boolean handleRequest(ReadStream is, WriteStream os) throws IOException {
        boolean isLoggable = log.isLoggable(Level.FINE);
        String host = "";
        String etag = null;
        block8: while (true) {
            int len;
            os.flush();
            int code = is.read();
            switch (code) {
                case -1: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + "end of file");
                    }
                    return false;
                }
                case 81: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + ": end of request");
                    }
                    return true;
                }
                case 88: {
                    if (isLoggable) {
                        log.fine(this.dbgId() + (char)code + ": end of socket");
                    }
                    return false;
                }
                case 101: {
                    len = (is.read() << 8) + is.read();
                    this._cb.clear();
                    is.readAll(this._cb, len);
                    etag = this._cb.toString();
                    if (!isLoggable) continue block8;
                    log.fine(this.dbgId() + "etag: " + etag);
                    continue block8;
                }
                case 104: {
                    len = (is.read() << 8) + is.read();
                    this._cb.clear();
                    is.readAll(this._cb, len);
                    host = this._cb.toString();
                    if (!isLoggable) continue block8;
                    log.fine(this.dbgId() + "host: " + host);
                    continue block8;
                }
                case 113: {
                    len = (is.read() << 8) + is.read();
                    this._cb.clear();
                    is.readAll(this._cb, len);
                    if (isLoggable) {
                        log.fine(this.dbgId() + "query: " + this._cb);
                    }
                    this.queryAll(os, host, this._cb.toString(), etag);
                    continue block8;
                }
            }
            len = (is.read() << 8) + is.read();
            if (isLoggable) {
                log.fine(this.dbgId() + (char)code + " " + len + " (dispatch)");
            }
            is.skip(len);
        }
    }

    private void queryAll(WriteStream os, String hostName, String url, String etag) throws IOException {
        int channel = 2;
        boolean isLoggable = log.isLoggable(Level.FINE);
        os.write(67);
        os.write(channel >> 8);
        os.write(channel);
        Host host = this._server.getHost(hostName, 80);
        if (host == null) {
            HostController controller = this._server.getHostController(hostName, 80);
            if (controller != null) {
                this.writeString(os, 117, "");
            } else {
                this.writeString(os, 72, "check-interval");
                this.writeString(os, 83, String.valueOf(this._server.getDependencyCheckInterval() / 1000L));
            }
            if (isLoggable) {
                log.fine(this.dbgId() + "host '" + hostName + "' not configured");
            }
            return;
        }
        if (!host.getState().isActive()) {
            this.writeString(os, 117, "");
            if (isLoggable) {
                log.fine(this.dbgId() + "host '" + host + "' not active");
            }
            return;
        }
        if (host.getConfigETag() == null) {
            this.sendQuery(null, host, hostName, url);
        }
        if (etag != null) {
            if (etag.equals(host.getConfigETag())) {
                if (isLoggable) {
                    log.fine(this.dbgId() + "host '" + host + "' no change");
                }
                this.writeString(os, 110, "");
                return;
            }
            if (etag.equals("h-" + host.getName())) {
                if (isLoggable) {
                    log.fine(this.dbgId() + "host alias '" + hostName + " -> '" + host + "' no change");
                }
                this.writeString(os, 110, "");
                return;
            }
            if (isLoggable) {
                log.fine(this.dbgId() + "host '" + host + "' changed");
            }
        }
        this.sendQuery(os, host, hostName, url);
    }

    private void sendQuery(WriteStream os, Host host, String hostName, String url) throws IOException {
        boolean isLoggable = log.isLoggable(Level.FINE);
        long crc64 = 0L;
        if (!CurrentTime.isTest()) {
            crc64 = Crc64.generate(crc64, VersionFactory.getFullVersion());
        }
        this.queryServer(os);
        String canonicalHostName = host.getHostName();
        if (canonicalHostName.equals("default")) {
            canonicalHostName = "";
        }
        this.writeString(os, 104, canonicalHostName);
        if (hostName.equals(canonicalHostName)) {
            crc64 = this.queryCluster(os, host, crc64);
            WebAppContainer webAppContainer = host.getWebAppContainer();
            WebAppController controller = webAppContainer.findByURI(url);
            if (controller != null) {
                try {
                    controller.request();
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            for (WebAppController appEntry : webAppContainer.getWebAppList()) {
                String pattern;
                int j;
                if (appEntry.getParent() != null && appEntry.getParent().isDynamicDeploy()) continue;
                this.writeString(os, 97, appEntry.getContextPath());
                if (isLoggable) {
                    log.fine(this.dbgId() + "web-app '" + appEntry.getContextPath() + "'");
                }
                crc64 = Crc64.generate(crc64, appEntry.getContextPath());
                WebApp app = appEntry.getWebApp();
                if (appEntry.isDynamicDeploy()) {
                    this.writeString(os, 109, "/*");
                    crc64 = Crc64.generate(crc64, "/*");
                    if (!isLoggable) continue;
                    log.fine(this.dbgId() + "dynamic '" + appEntry.getContextPath() + "'");
                    continue;
                }
                if (app == null || !app.isActive()) {
                    if (isLoggable) {
                        log.fine(this.dbgId() + "not active '" + appEntry.getContextPath() + "'");
                    }
                    this.writeString(os, 85, "");
                    continue;
                }
                if (isLoggable) {
                    log.fine(this.dbgId() + "active '" + appEntry.getContextPath() + "'");
                }
                ArrayList<String> patternList = app.getServletMappingPatterns();
                for (j = 0; patternList != null && j < patternList.size(); ++j) {
                    pattern = patternList.get(j);
                    this.writeString(os, 109, pattern);
                    crc64 = Crc64.generate(crc64, pattern);
                }
                patternList = app.getServletIgnoreMappingPatterns();
                for (j = 0; patternList != null && j < patternList.size(); ++j) {
                    pattern = patternList.get(j);
                    this.writeString(os, 105, pattern);
                    crc64 = Crc64.generate(crc64, "i");
                    crc64 = Crc64.generate(crc64, pattern);
                }
            }
            CharBuffer cb = new CharBuffer();
            Base64.encode(cb, crc64);
            String newETag = cb.close();
            host.setConfigETag(newETag);
            this.writeString(os, 101, host.getConfigETag());
        } else {
            this.writeString(os, 101, "h-" + host.getName());
        }
    }

    private long queryCluster(WriteStream os, Host host, long crc64) throws IOException {
        CloudServer[] servers;
        CloudCluster cluster = host.getCluster();
        if (cluster == null) {
            return 0L;
        }
        this.writeString(os, 99, cluster.getId());
        crc64 = Crc64.generate(crc64, cluster.getId());
        CloudPod[] pods = cluster.getPodList();
        int serverLength = pods.length > 0 ? pods[0].getServerLength() : 0;
        CloudServer[] cloudServerArray = servers = pods.length > 0 ? pods[0].getServerList() : null;
        if (serverLength > 0) {
            CloudServer cloudServer = servers[0];
            ClusterServer server = cloudServer.getData(ClusterServer.class);
            crc64 = this.writeTime(os, crc64, "live-time", server.getLoadBalanceIdleTime());
            crc64 = this.writeTime(os, crc64, "dead-time", server.getLoadBalanceRecoverTime());
            crc64 = this.writeTime(os, crc64, "read-timeout", server.getLoadBalanceSocketTimeout());
            crc64 = this.writeTime(os, crc64, "connect-timeout", server.getLoadBalanceConnectTimeout());
        }
        for (int i = 0; i < serverLength; ++i) {
            ClusterServer server;
            CloudServer cloudServer = servers[i];
            if (cloudServer == null || (server = cloudServer.getData(ClusterServer.class)) == null) continue;
            String srunHost = server.getIp() + ":" + server.getPort();
            boolean isSSL = false;
            if (server.isBackup()) {
                this.writeString(os, 98, srunHost);
            } else if (isSSL) {
                this.writeString(os, 101, srunHost);
            } else {
                this.writeString(os, 115, srunHost);
            }
            crc64 = Crc64.generate(crc64, srunHost);
        }
        return crc64;
    }

    private long writeTime(WriteStream os, long crc, String header, long time) throws IOException {
        crc = Crc64.generate(crc, time);
        this.writeTime(os, header, time);
        return crc;
    }

    private void writeTime(WriteStream os, String header, long time) throws IOException {
        this.writeString(os, 72, header);
        this.writeString(os, 83, "" + (time + 999L) / 1000L);
    }

    private void queryServer(WriteStream os) throws IOException {
        this.writeTime(os, "check-interval", this._server.getDependencyCheckInterval());
        this.writeString(os, 72, "cookie");
        this.writeString(os, 83, this._server.getSessionCookie());
        this.writeString(os, 72, "ssl-cookie");
        this.writeString(os, 83, this._server.getSSLSessionCookie());
        this.writeString(os, 72, "session-url-prefix");
        this.writeString(os, 83, this._server.getSessionURLPrefix());
        this.writeString(os, 72, "alt-session-url-prefix");
        this.writeString(os, 83, this._server.getAlternateSessionURLPrefix());
        if (this._server.getConnectionErrorPage() != null) {
            this.writeString(os, 72, "connection-error-page");
            this.writeString(os, 83, this._server.getConnectionErrorPage());
        }
    }

    void writeString(WriteStream os, int code, String value) throws IOException {
        if (os == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        int len = value.length();
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(value);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (char)code + " " + value);
        }
    }

    void writeString(WriteStream os, int code, CharBuffer value) throws IOException {
        if (os == null) {
            return;
        }
        int len = value.length();
        os.write(code);
        os.write(len >> 8);
        os.write(len);
        os.print(value);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (char)code + " " + value);
        }
    }

    private String dbgId() {
        return this._request.dbgId();
    }
}

