/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.host;

import com.caucho.bam.broker.Broker;
import com.caucho.bam.broker.ManagedBroker;
import com.caucho.cloud.network.NetworkListenSystem;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.SchemaBean;
import com.caucho.config.inject.InjectManager;
import com.caucho.env.deploy.EnvironmentDeployInstance;
import com.caucho.env.service.ResinSystem;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.hemp.broker.HempBrokerManager;
import com.caucho.http.log.AccessLog;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.make.AlwaysModified;
import com.caucho.management.server.HostMXBean;
import com.caucho.network.listen.TcpPort;
import com.caucho.rewrite.DispatchRule;
import com.caucho.rewrite.RewriteFilter;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.ExceptionFilterChain;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationBuilder;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.e_app.EarDeployGenerator;
import com.caucho.server.host.HostContainer;
import com.caucho.server.host.HostController;
import com.caucho.server.resin.Resin;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.ErrorPageManager;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppExpandDeployGenerator;
import com.caucho.util.HostUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Host
implements EnvironmentBean,
Dependency,
SchemaBean,
EnvironmentDeployInstance,
InvocationBuilder {
    private static final L10N L = new L10N(Host.class);
    private static final Logger log = Logger.getLogger(Host.class.getName());
    private static EnvironmentLocal<Host> _hostLocal = new EnvironmentLocal("caucho.host");
    private final ServletService _servletContainer;
    private final HostContainer _parent;
    private final HostController _controller;
    private final Path _rootDirectory;
    private EnvironmentClassLoader _classLoader;
    private String _hostName = "";
    private String _url;
    private String _serverName = "";
    private int _serverPort = 0;
    private final WebAppContainer _webAppContainer;
    private ErrorPageManager _errorPageManager;
    private String _secureHostName;
    private Boolean _isSecure;
    private boolean _isDefaultHost;
    private ArrayList<String> _aliasList = new ArrayList();
    private HempBroker _bamBroker;
    private Throwable _configException;
    private String _configETag = null;
    private final Lifecycle _lifecycle;

    public Host(HostContainer parent, HostController controller, String hostName) {
        this._servletContainer = parent.getServer();
        if (this._servletContainer == null) {
            throw new IllegalStateException(L.l("Host requires an active Servlet container"));
        }
        this._classLoader = EnvironmentClassLoader.create("host:" + controller.getName());
        this._parent = parent;
        this._controller = controller;
        this._rootDirectory = controller.getRootDirectory();
        this._lifecycle = controller.getId().startsWith("error/") ? new Lifecycle(log, "Host[" + controller.getId() + "]", Level.FINEST) : new Lifecycle(log, "Host[" + controller.getId() + "]", Level.INFO);
        InjectManager.create(this._classLoader);
        this._webAppContainer = new WebAppContainer(this._servletContainer, this, this._rootDirectory, this.getClassLoader(), this._lifecycle);
        try {
            this.setHostName(hostName);
            _hostLocal.set(this, this.getClassLoader());
        }
        catch (Exception e) {
            this._configException = e;
        }
    }

    public static Host getLocal() {
        return _hostLocal.get();
    }

    @Configurable
    public void setHostName(String name) throws ConfigException {
        this._hostName = name;
        if (name.equals("")) {
            this._isDefaultHost = true;
        }
        this.addHostAlias(name);
        int p = name.indexOf("://");
        if (p >= 0) {
            name = name.substring(p + 3);
        }
        this._serverName = name;
        p = name.lastIndexOf(58);
        if (p > 0) {
            this._serverName = name.substring(0, p);
            boolean isPort = true;
            int port = 0;
            ++p;
            while (p < name.length()) {
                char ch = name.charAt(p);
                if ('0' <= ch && ch <= '9') {
                    port = 10 * port + ch - 48;
                } else {
                    isPort = false;
                }
                ++p;
            }
            if (isPort) {
                this._serverPort = port;
            }
        }
    }

    public String getName() {
        return this._controller.getName();
    }

    public String getHostName() {
        return this._hostName;
    }

    public String getSecureHostName() {
        return this._secureHostName;
    }

    public void setSecureHostName(String secureHostName) {
        this._secureHostName = secureHostName;
    }

    public void setSetRequestSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    public Boolean isRequestSecure() {
        return this._isSecure;
    }

    public Broker getBamBroker() {
        return this._bamBroker;
    }

    @Override
    public String getSchema() {
        return "com/caucho/server/host/host.rnc";
    }

    public String getId() {
        return this._controller.getId();
    }

    public String getIdTail() {
        String id = this._controller.getId();
        int p = id.indexOf("/host/");
        return id.substring(p + 6);
    }

    public String getURL() {
        if (this._url != null && !"".equals(this._url)) {
            return this._url;
        }
        if (this._hostName == null || this._hostName.equals("") || this._hostName.equals("default")) {
            ServletService server = this.getServer();
            if (server == null) {
                return "http://localhost";
            }
            ResinSystem resinSystem = server.getResinSystem();
            NetworkListenSystem listenService = resinSystem.getService(NetworkListenSystem.class);
            for (TcpPort port : listenService.getListeners()) {
                if (!"http".equals(port.getProtocolName())) continue;
                String address = port.getAddress();
                if (address == null || address.equals("")) {
                    address = "localhost";
                }
                return "http://" + address + ":" + port.getPort();
            }
            for (TcpPort port : listenService.getListeners()) {
                if (!"https".equals(port.getProtocolName())) continue;
                String address = port.getAddress();
                if (address == null || address.equals("")) {
                    address = "localhost";
                }
                return "https://" + address + ":" + port.getPort();
            }
            return "http://localhost";
        }
        if (this._hostName.startsWith("http:") || this._hostName.startsWith("https:")) {
            return this._hostName;
        }
        if (this._hostName.equals("") || this._hostName.equals("default")) {
            return "http://localhost";
        }
        return "http://" + this._hostName;
    }

    public void addHostAlias(String name) {
        if (!this._aliasList.contains(name = name.toLowerCase(Locale.ENGLISH))) {
            this._aliasList.add(name);
        }
        if (name.equals("") || name.equals("*")) {
            this._isDefaultHost = true;
        }
        this._controller.addExtHostAlias(name);
    }

    public LifecycleState getState() {
        return this._lifecycle.getState();
    }

    public ArrayList<String> getAliasList() {
        return this._aliasList;
    }

    @Configurable
    public void addHostAliasRegexp(String name) {
        name = name.trim();
        Pattern pattern = Pattern.compile(name, 2);
        this._controller.addExtHostAliasRegexp(pattern);
    }

    public boolean isDefaultHost() {
        return this._isDefaultHost;
    }

    @Override
    public EnvironmentClassLoader getClassLoader() {
        return this._classLoader;
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    @Configurable
    public void setAccessLog(AccessLog log) {
        this._webAppContainer.setAccessLog(log);
    }

    public void setDocumentDirectory(Path docDir) {
        this._webAppContainer.setDocumentDirectory(docDir);
    }

    public WebAppContainer getWebAppContainer() {
        return this._webAppContainer;
    }

    @Configurable
    public void addErrorPage(ErrorPage errorPage) {
        this.getErrorPageManager().addErrorPage(errorPage);
    }

    public ErrorPageManager getErrorPageManager() {
        if (this._errorPageManager == null) {
            this._errorPageManager = new ErrorPageManager(this.getServer(), this, null);
        }
        return this._errorPageManager;
    }

    @Configurable
    public void addWebApp(WebAppConfig config) {
        this.getWebAppContainer().addWebApp(config);
    }

    @Configurable
    public void addWebAppDefault(WebAppConfig config) {
        this.getWebAppContainer().addWebAppDefault(config);
    }

    @Configurable
    public WebAppExpandDeployGenerator createWarDeploy() {
        return this.getWebAppContainer().createWebAppDeploy();
    }

    @Configurable
    public void addWarDeploy(WebAppExpandDeployGenerator webAppDeploy) throws ConfigException {
        this.getWebAppContainer().addWarDeploy(webAppDeploy);
    }

    @Configurable
    public WebAppExpandDeployGenerator createWebAppDeploy() {
        return this.getWebAppContainer().createWebAppDeploy();
    }

    public void addWebAppDeploy(WebAppExpandDeployGenerator deploy) throws ConfigException {
        this.getWebAppContainer().addWebAppDeploy(deploy);
    }

    @Configurable
    public EarDeployGenerator createEarDeploy() throws Exception {
        return this.getWebAppContainer().createEarDeploy();
    }

    @Configurable
    public void addEarDeploy(EarDeployGenerator earDeploy) throws Exception {
        this.getWebAppContainer().addEarDeploy(earDeploy);
    }

    @Configurable
    public void addEarDefault(EarConfig config) {
        this.getWebAppContainer().addEarDefault(config);
    }

    @Configurable
    public void setWarDir(Path warDir) throws ConfigException {
        this.getWebAppContainer().setWarDir(warDir);
    }

    public void setWarExpandDir(Path warDir) {
        this.getWebAppContainer().setWarExpandDir(warDir);
    }

    public void add(DispatchRule dispatchRule) {
        this._webAppContainer.add(dispatchRule);
    }

    public void add(RewriteFilter dispatchAction) {
        this._webAppContainer.add(dispatchAction);
    }

    public RewriteDispatch createRewriteDispatch() {
        return this._webAppContainer.createRewriteDispatch();
    }

    @Override
    public void setConfigException(Throwable e) {
        if (e != null) {
            this._configException = e;
            this._classLoader.addDependency(AlwaysModified.create());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    @Override
    public Throwable getConfigException() {
        return this._configException;
    }

    public ServletService getServer() {
        return this._parent.getServer();
    }

    public CloudCluster getCluster() {
        ServletService server = this.getServer();
        if (server != null) {
            return server.getCluster();
        }
        return null;
    }

    public String getConfigETag() {
        return this._configETag;
    }

    public void setConfigETag(String etag) {
        this._configETag = etag;
    }

    public HostMXBean getAdmin() {
        return this._controller.getAdmin();
    }

    @Override
    public void preConfigInit() {
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (!this._lifecycle.toStarting()) {
            return;
        }
        if (this.getURL().equals("") && this._parent != null) {
            this._url = this._parent.getURL();
        }
        EnvironmentClassLoader loader = this._classLoader;
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            this.initBam();
            loader.start();
            this.getWebAppContainer().start();
            if (this._parent != null) {
                this._parent.clearCache();
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        this._lifecycle.toActive();
    }

    private void initBam() {
        if (Resin.getCurrent() == null) {
            return;
        }
        String hostName = this._hostName;
        if ("".equals(hostName)) {
            hostName = HostUtil.getLocalHostName();
        }
        HempBrokerManager brokerManager = HempBrokerManager.getCurrent();
        this._bamBroker = new HempBroker(brokerManager, hostName);
        if (brokerManager != null) {
            brokerManager.addBroker(hostName, this._bamBroker);
        }
        for (String alias : this._aliasList) {
            this._bamBroker.addAlias(alias);
            if (brokerManager == null) continue;
            brokerManager.addBroker(alias, this._bamBroker);
        }
        InjectManager cdiManager = InjectManager.getCurrent();
        cdiManager.addBeanDiscover(cdiManager.createBeanFactory(ManagedBroker.class).name("bamBroker").singleton(this._bamBroker));
    }

    public void clearCache() {
        this._parent.clearCache();
        this._webAppContainer.clearCache();
        this.setConfigETag(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invocation buildInvocation(Invocation invocation) throws ConfigException {
        invocation.setHostName(this._serverName);
        invocation.setPort(this._serverPort);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            if (this._configException == null) {
                Invocation invocation2 = this._webAppContainer.buildInvocation(invocation);
                return invocation2;
            }
            invocation.setFilterChain(new ExceptionFilterChain(this._configException));
            invocation.setDependency(AlwaysModified.create());
            Invocation invocation3 = invocation;
            return invocation3;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    @Override
    public boolean isModified() {
        return this._lifecycle.isDestroyed() || this._classLoader.isModified();
    }

    @Override
    public boolean isModifiedNow() {
        return this._lifecycle.isDestroyed() || this._classLoader.isModifiedNow();
    }

    @Override
    public boolean logModified(Logger log) {
        if (this._lifecycle.isDestroyed()) {
            log.finer(this + " is destroyed");
            return true;
        }
        return this._classLoader.logModified(log);
    }

    public boolean isDeployError() {
        return this._configException != null;
    }

    @Override
    public boolean isDeployIdle() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            EnvironmentClassLoader envLoader = this._classLoader;
            thread.setContextClassLoader(envLoader);
            if (!this._lifecycle.toStopping()) {
                boolean bl = false;
                return bl;
            }
            this._webAppContainer.stop();
            if (this._bamBroker != null) {
                this._bamBroker.close();
            }
            envLoader.stop();
            boolean bl = true;
            return bl;
        }
        finally {
            this._lifecycle.toStop();
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        EnvironmentClassLoader classLoader = this._classLoader;
        thread.setContextClassLoader(classLoader);
        try {
            this._webAppContainer.destroy();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
            classLoader.destroy();
        }
    }

    public static String calculateCanonicalIPv6(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return "[" + addr.getHostAddress() + "]";
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return host;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }
}

