/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractResponseStream;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ToByteResponseStream
extends AbstractResponseStream {
    private static final L10N L = new L10N(ToByteResponseStream.class);
    private static final Logger log = Logger.getLogger(ToByteResponseStream.class.getName());
    protected static final int SIZE = TempBuffer.SIZE;
    private final char[] _charBuffer = new char[SIZE];
    private int _charLength;
    private final TempBuffer _head = TempBuffer.allocate();
    private TempBuffer _tail;
    private byte[] _tailByteBuffer;
    private int _tailByteLength;
    private int _bufferCapacity;
    private int _bufferSize;
    private boolean _isOutputStreamOnly;
    private boolean _isCharFlushing;
    private EncodingWriter _toByte = Encoding.getLatin1Writer();

    protected ToByteResponseStream() {
    }

    @Override
    public void start() {
        super.start();
        this._bufferCapacity = SIZE;
        this.clearBuffer();
        this._isOutputStreamOnly = false;
        this._toByte = Encoding.getLatin1Writer();
    }

    @Override
    public boolean isCauchoResponseStream() {
        return true;
    }

    @Override
    public void setOutputStreamOnly(boolean isOutputStreamOnly) {
        this._isOutputStreamOnly = isOutputStreamOnly;
    }

    protected boolean setFlush(boolean isAllowFlush) {
        return true;
    }

    @Override
    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        EncodingWriter toByte = encoding == null ? Encoding.getLatin1Writer() : Encoding.getWriteEncoding(encoding);
        if (toByte == null) {
            this._toByte = Encoding.getLatin1Writer();
            throw new UnsupportedEncodingException(encoding);
        }
        this._toByte = toByte;
    }

    @Override
    public void setLocale(Locale locale) throws UnsupportedEncodingException {
    }

    @Override
    public final char[] getCharBuffer() {
        return this._charBuffer;
    }

    @Override
    public int getCharOffset() throws IOException {
        return this._charLength;
    }

    @Override
    public void setCharOffset(int offset) throws IOException {
        this._charLength = offset;
        if (this._charLength == SIZE) {
            this.flushCharBuffer();
        }
    }

    @Override
    public byte[] getBuffer() throws IOException {
        if (!this._isOutputStreamOnly) {
            this.flushCharBuffer();
        }
        return this._tailByteBuffer;
    }

    @Override
    public int getBufferOffset() throws IOException {
        if (!this._isOutputStreamOnly) {
            this.flushCharBuffer();
        }
        return this._tailByteLength;
    }

    public int getByteBufferOffset() throws IOException {
        return this._tailByteLength;
    }

    @Override
    public void setBufferOffset(int offset) throws IOException {
        this._tailByteLength = offset;
    }

    @Override
    public int getBufferSize() {
        return this._bufferCapacity;
    }

    @Override
    public void setBufferSize(int size) {
        this._bufferCapacity = SIZE * ((size + SIZE - 1) / SIZE);
        if (this._bufferCapacity <= 0) {
            this._bufferCapacity = 0;
        }
    }

    @Override
    public int getRemaining() {
        return this._bufferCapacity - this.getBufferLength();
    }

    protected int getBufferLength() {
        return this._bufferSize + this._tailByteLength + this._charLength;
    }

    protected boolean isDisableAutoFlush() {
        return false;
    }

    @Override
    public void clearBuffer() {
        TempBuffer next = this._head.getNext();
        if (next != null) {
            this._head.setNext(null);
            TempBuffer.freeAll(next);
        }
        this._head.clear();
        this._tail = this._head;
        this._tailByteBuffer = this._tail.getBuffer();
        this._tailByteLength = 0;
        this._charLength = 0;
        this._bufferSize = 0;
    }

    @Override
    public void write(int ch) throws IOException {
        if (this.isClosed() || this.isHead()) {
            return;
        }
        if (this._charLength > 0) {
            this.flushCharBuffer();
        }
        if (this._bufferCapacity <= this._bufferSize + this._tailByteLength + 1) {
            this.flushByteBuffer();
        } else if (this._tailByteLength == SIZE) {
            this._tail.setLength(this._tailByteLength);
            this._bufferSize += this._tailByteLength;
            TempBuffer tempBuf = TempBuffer.allocate();
            this._tail.setNext(tempBuf);
            this._tail = tempBuf;
            this._tailByteBuffer = this._tail.getBuffer();
            this._tailByteLength = 0;
        }
        this._tailByteBuffer[this._tailByteLength++] = (byte)ch;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.isClosed() || this.isHead()) {
            return;
        }
        if (this._charLength > 0) {
            this.flushCharBuffer();
        }
        if (this._bufferCapacity <= this._bufferSize + this._tailByteLength + length) {
            if (this._bufferSize + this._tailByteLength > 0) {
                this.flushByteBuffer();
            }
            if (this._bufferCapacity <= length) {
                this.writeHeaders(-1);
                boolean isFinished = false;
                this.writeNext(buffer, offset, length, isFinished);
                this._bufferSize = 0;
                return;
            }
        }
        int byteLength = this._tailByteLength;
        while (length > 0) {
            int sublen;
            if (SIZE <= byteLength) {
                this._tail.setLength(byteLength);
                this._bufferSize += byteLength;
                TempBuffer tempBuf = TempBuffer.allocate();
                this._tail.setNext(tempBuf);
                this._tail = tempBuf;
                this._tailByteBuffer = this._tail.getBuffer();
                byteLength = 0;
            }
            if (SIZE - byteLength < (sublen = length)) {
                sublen = SIZE - byteLength;
            }
            System.arraycopy(buffer, offset, this._tailByteBuffer, byteLength, sublen);
            offset += sublen;
            length -= sublen;
            byteLength += sublen;
        }
        this._tailByteLength = byteLength;
    }

    @Override
    public void print(int ch) throws IOException {
        if (this.isClosed() || this.isHead()) {
            return;
        }
        if (SIZE <= this._charLength) {
            this.flushCharBuffer();
        }
        this._charBuffer[this._charLength++] = (char)ch;
    }

    @Override
    public void print(char[] buffer, int offset, int length) throws IOException {
        if (this.isClosed() || this.isHead()) {
            return;
        }
        int charLength = this._charLength;
        while (length > 0) {
            int sublen = SIZE - charLength;
            if (length < sublen) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, this._charBuffer, charLength, sublen);
            offset += sublen;
            if ((charLength += sublen) != SIZE || (length -= sublen) <= 0) continue;
            this._charLength = charLength;
            this.flushCharBuffer();
            charLength = this._charLength;
        }
        this._charLength = charLength;
    }

    @Override
    public char[] nextCharBuffer(int offset) throws IOException {
        this._charLength = offset;
        this.flushCharBuffer();
        return this._charBuffer;
    }

    protected boolean isCharFlushing() {
        return this._isCharFlushing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushCharBuffer() throws IOException {
        int charLength = this._charLength;
        this._charLength = 0;
        if (charLength > 0 && !this._isOutputStreamOnly) {
            this._isCharFlushing = true;
            try {
                boolean isFlush = this.setFlush(false);
                int writeLength = this._toByte.write(this, this._charBuffer, 0, charLength);
                if (writeLength < charLength) {
                    System.arraycopy(this._charBuffer, writeLength, this._charBuffer, 0, charLength - writeLength);
                    this._charLength = charLength - writeLength;
                }
                this.setFlush(isFlush);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
            finally {
                this._isCharFlushing = false;
            }
            if (this._bufferCapacity <= this._tailByteLength + this._bufferSize) {
                this.flushByteBuffer();
            }
        }
    }

    @Override
    public int getContentLength() {
        try {
            this.flushCharBuffer();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return this._bufferSize + this._tailByteLength;
    }

    @Override
    public byte[] nextBuffer(int offset) throws IOException {
        if (offset < 0 || SIZE < offset) {
            throw new IllegalStateException(L.l("Invalid offset: " + offset));
        }
        if (this._bufferCapacity <= SIZE || this._bufferCapacity <= offset + this._bufferSize) {
            this._tailByteLength = offset;
            this.flushByteBuffer();
            return this.getBuffer();
        }
        this._tail.setLength(offset);
        this._bufferSize += offset;
        TempBuffer tempBuf = TempBuffer.allocate();
        this._tail.setNext(tempBuf);
        this._tail = tempBuf;
        this._tailByteBuffer = this._tail.getBuffer();
        this._tailByteLength = 0;
        return this._tailByteBuffer;
    }

    protected void flushByteBuffer() throws IOException {
        TempBuffer next;
        if (this.isDisableAutoFlush()) {
            throw new IOException("auto-flush is disabled");
        }
        boolean isFinished = this.isClosing();
        if (this._tailByteLength == 0 && this._bufferSize == 0) {
            if (!this.isCommitted()) {
                this.writeHeaders(0);
            }
            return;
        }
        this._tail.setLength(this._tailByteLength);
        this._bufferSize += this._tailByteLength;
        this._tailByteLength = 0;
        this.writeHeaders(this._bufferSize);
        TempBuffer ptr = this._head;
        do {
            next = ptr.getNext();
            ptr.setNext(null);
            this.writeNext(ptr.getBuffer(), 0, ptr.getLength(), isFinished);
            if (ptr == this._head) continue;
            TempBuffer.free(ptr);
            ptr = null;
        } while ((ptr = next) != null);
        this._tail = this._head;
        this._tail.setLength(0);
        this._tailByteBuffer = this._tail.getBuffer();
        this._bufferSize = 0;
    }

    protected void writeHeaders(int length) throws IOException {
    }

    protected abstract void writeNext(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    @Override
    public void flushBuffer() throws IOException {
        if (this.isDisableAutoFlush()) {
            throw new IOException("auto-flush is disabled");
        }
        if (this._charLength > 0) {
            this.flushCharBuffer();
        }
        this.flushByteBuffer();
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
    }

    @Override
    protected void closeImpl() throws IOException {
        this.flushBuffer();
    }
}

