/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.remote.websocket.FrameInputStream;
import com.caucho.remote.websocket.WebSocketBlockingQueue;
import com.caucho.remote.websocket.WebSocketConstants;
import com.caucho.remote.websocket.WebSocketInputStream;
import com.caucho.remote.websocket.WebSocketOutputStream;
import com.caucho.remote.websocket.WebSocketPrintWriter;
import com.caucho.remote.websocket.WebSocketReader;
import com.caucho.remote.websocket.WebSocketWriter;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import com.caucho.websocket.WebSocketContext;
import com.caucho.websocket.WebSocketEncoder;
import com.caucho.websocket.WebSocketListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

class WebSocketContextImpl
implements WebSocketContext,
WebSocketConstants,
SocketLinkDuplexListener {
    private static final L10N L = new L10N(WebSocketContextImpl.class);
    private static final Logger log = Logger.getLogger(WebSocketContextImpl.class.getName());
    private final HttpServletRequestImpl _request;
    private final WebSocketListener _listener;
    private SocketLinkDuplexController _controller;
    private FrameInputStream _is;
    private WebSocketOutputStream _binaryOut;
    private WebSocketInputStream _binaryIn;
    private WebSocketWriter _textOut;
    private PrintWriter _textWriter;
    private boolean _isReadClosed;
    private AtomicBoolean _isWriteClosed = new AtomicBoolean();

    WebSocketContextImpl(HttpServletRequestImpl request, HttpServletResponseImpl response, WebSocketListener listener, FrameInputStream is) {
        this._request = request;
        this._listener = listener;
        this._is = is;
    }

    public void setController(SocketLinkDuplexController controller) {
        this._controller = controller;
        this._is.init(this, controller.getReadStream());
    }

    @Override
    public void setTimeout(long timeout) {
        this._controller.setIdleTimeMax(timeout);
    }

    @Override
    public long getTimeout() {
        return this._controller.getIdleTimeMax();
    }

    @Override
    public <T> BlockingQueue<T> createOutputQueue(WebSocketEncoder<T> encoder) {
        return new WebSocketBlockingQueue<T>(this, encoder, 256);
    }

    @Override
    public void setAutoFlush(boolean isAutoFlush) {
    }

    @Override
    public boolean isAutoFlush() {
        return false;
    }

    @Override
    public OutputStream startBinaryMessage() throws IOException {
        if (this._isWriteClosed.get()) {
            throw new IllegalStateException(L.l("{0} is closed for writing.", (Object)this));
        }
        if (this._binaryOut == null) {
            this._binaryOut = new WebSocketOutputStream(this._controller.getWriteStream(), TempBuffer.allocate().getBuffer());
        }
        this._binaryOut.init();
        return this._binaryOut;
    }

    @Override
    public PrintWriter startTextMessage() throws IOException {
        if (this._textOut == null) {
            this._textOut = new WebSocketWriter(this._controller.getWriteStream(), TempBuffer.allocate().getBuffer());
            this._textWriter = new WebSocketPrintWriter(this._textOut);
        }
        this._textOut.init();
        return this._textWriter;
    }

    @Override
    public void ping(byte[] value) throws IOException {
        WriteStream out = this._controller.getWriteStream();
        byte[] bytes = value;
        out.write(137);
        out.write(bytes.length);
        out.write(bytes);
        out.flush();
    }

    @Override
    public void pong(byte[] value) throws IOException {
        WriteStream out = this._controller.getWriteStream();
        byte[] bytes = value;
        out.write(138);
        out.write(bytes.length);
        out.write(bytes);
        out.flush();
    }

    public boolean isClosed() {
        return this._isWriteClosed.get();
    }

    @Override
    public void close() {
        this.close(1000, "ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(int code, String message) {
        if (this._isWriteClosed.getAndSet(true)) {
            return;
        }
        WriteStream out = this._controller.getWriteStream();
        try {
            if (code <= 0) {
                out.write(136);
                out.write(0);
            } else {
                byte[] bytes = message.getBytes("utf-8");
                out.write(136);
                out.write(2 + bytes.length);
                out.write(code >> 8 & 0xFF);
                out.write(code & 0xFF);
                out.write(bytes);
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            IoUtil.close(out);
            this.disconnect();
        }
    }

    @Override
    public void disconnect() {
        this._isWriteClosed.set(true);
        try {
            this._controller.complete();
        }
        finally {
            IoUtil.close(this._is);
        }
    }

    void onStart() throws IOException {
        this._listener.onStart(this);
    }

    @Override
    public void flush() throws IOException {
        WriteStream out = this._controller.getWriteStream();
        out.flush();
    }

    @Override
    public void onStart(SocketLinkDuplexController context) throws IOException {
    }

    @Override
    public void onRead(SocketLinkDuplexController duplex) throws IOException {
        do {
            if (this.readFrame()) continue;
            return;
        } while (this._request.getBufferAvailable() > 0);
    }

    private boolean readFrame() throws IOException {
        if (!this._is.readFrameHeader()) {
            return false;
        }
        int opcode = this._is.getOpcode();
        switch (opcode) {
            case 2: {
                if (this._binaryIn == null) {
                    this._binaryIn = this.createWebSocketInputStream(this._is);
                }
                this._binaryIn.init();
                try {
                    this._listener.onReadBinary(this, this._binaryIn);
                    break;
                }
                finally {
                    this._binaryIn.close();
                }
            }
            case 1: {
                WebSocketReader textIn = this._is.initReader(this._is.getLength(), this._is.isFinal());
                try {
                    this._listener.onReadText(this, textIn);
                    break;
                }
                finally {
                    textIn.close();
                }
            }
            default: {
                log.fine(this + " unexpected opcode " + opcode);
                this.disconnect();
                return false;
            }
        }
        return true;
    }

    protected WebSocketInputStream createWebSocketInputStream(FrameInputStream is) throws IOException {
        return new WebSocketInputStream(is);
    }

    @Override
    public void onDisconnect(SocketLinkDuplexController duplex) throws IOException {
        this._listener.onDisconnect(this);
    }

    @Override
    public void onTimeout(SocketLinkDuplexController duplex) throws IOException {
        this._listener.onTimeout(this);
    }

    @Override
    public void onClose(int closeCode, String closeMessage) {
        try {
            this._listener.onClose(this);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._listener + "]";
    }
}

