/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.httpcache;

import com.caucho.config.ConfigException;
import com.caucho.db.Database;
import com.caucho.db.block.BlockStore;
import com.caucho.server.httpcache.TempFileInode;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStreamApi;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class TempFileManager {
    private static final L10N L = new L10N(TempFileManager.class);
    private static final Logger log = Logger.getLogger(TempFileManager.class.getName());
    private final BlockStore _store;

    public TempFileManager(Path path) {
        String name = "temp_file";
        Path storePath = path.lookup(name);
        try {
            path.getParent().mkdirs();
            storePath.remove();
            if (storePath.exists()) {
                log.warning(L.l("Removal of old temp file '{0}' failed. Please check permissions.", (Object)storePath.getNativePath()));
            }
            Database database = new Database();
            database.ensureMemoryCapacity(0x100000L);
            database.init();
            this._store = new BlockStore(database, name, null, storePath);
            this._store.setFlushDirtyBlocksOnCommit(false);
            this._store.create();
        }
        catch (Exception e) {
            throw ConfigException.create(L.l("While creating temp file {0}, an Exception occurred {1}. Check disk space", (Object)storePath.getNativePath(), (Object)e.toString()), (Throwable)e);
        }
        catch (Error e) {
            log.warning(L.l("While creating temp file {0}, an Error occurred {1}. Check disk space", (Object)storePath.getNativePath(), (Object)e.toString()));
            throw e;
        }
    }

    public void close() {
        this._store.close();
    }

    public TempFileInode createInode() {
        return new TempFileInode(this._store);
    }

    public TempStreamApi createTempStream() {
        TempFileInode inode = this.createInode();
        return new TempStreamImpl(inode);
    }

    class TempStreamImpl
    implements TempStreamApi {
        private TempFileInode _inode;
        private OutputStream _os;

        TempStreamImpl(TempFileInode inode) {
            this._inode = inode;
            this._os = inode.openOutputStream();
        }

        @Override
        public ReadStream openRead() throws IOException {
            OutputStream os = this._os;
            if (os != null) {
                os.close();
            }
            return Vfs.openRead(this._inode.openInputStream());
        }

        @Override
        public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
            this._os.write(buffer, offset, length);
        }

        @Override
        public void destroy() {
            TempFileInode inode = this._inode;
            this._inode = null;
            if (inode != null) {
                inode.free();
            }
        }
    }
}

