/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.log;

import com.caucho.env.thread.ThreadPool;
import com.caucho.server.log.AccessLogWriter;
import java.util.concurrent.locks.LockSupport;

public final class LogBuffer {
    private final boolean _isPrivate;
    private final byte[] _logBuffer;
    private volatile int _length;
    private volatile Thread _thread;

    public LogBuffer(int size) {
        this(size, false);
    }

    public LogBuffer(int size, boolean isPrivate) {
        this._logBuffer = new byte[size];
        this._isPrivate = isPrivate;
    }

    public boolean isPrivate() {
        return this._isPrivate;
    }

    public final byte[] getBuffer() {
        return this._logBuffer;
    }

    public final void setLength(int length) {
        this._length = length;
    }

    public final int getLength() {
        return this._length;
    }

    public final boolean allocate(AccessLogWriter logWriter) {
        if (this._length == 0) {
            return true;
        }
        if (logWriter.isBufferAvailable()) {
            return false;
        }
        logWriter.wake();
        this._thread = Thread.currentThread();
        try {
            if (this._length != 0) {
                LockSupport.parkNanos(250000L);
            }
        }
        finally {
            this._thread = null;
        }
        return this._length == 0;
    }

    public final void clear() {
        this._length = 0;
        Thread thread = this._thread;
        if (thread != null) {
            ThreadPool.getCurrent().scheduleUnpark(thread);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

