/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.VersionFactory;
import com.caucho.bam.broker.Broker;
import com.caucho.cloud.bam.BamSystem;
import com.caucho.cloud.license.LicenseClient;
import com.caucho.cloud.loadbalance.LoadBalanceService;
import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.network.NetworkClusterSystem;
import com.caucho.cloud.network.NetworkListenSystem;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.core.ResinProperties;
import com.caucho.config.inject.WebBeansAddLoaderListener;
import com.caucho.config.program.ConfigProgram;
import com.caucho.ejb.manager.EjbEnvironmentListener;
import com.caucho.env.deploy.DeployControllerService;
import com.caucho.env.git.GitSystem;
import com.caucho.env.jpa.ListenerPersistenceEnvironment;
import com.caucho.env.log.LogSystem;
import com.caucho.env.repository.AbstractRepository;
import com.caucho.env.repository.LocalRepositoryService;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.env.repository.RepositorySystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.service.RootDirectorySystem;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.env.vfs.RepositoryScheme;
import com.caucho.java.WorkDir;
import com.caucho.license.LicenseCheck;
import com.caucho.license.LicenseStore;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.admin.Management;
import com.caucho.server.admin.StatSystem;
import com.caucho.server.cluster.ServerConfig;
import com.caucho.server.cluster.ServletContainerConfig;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.cluster.ServletSystem;
import com.caucho.server.resin.BootClusterConfig;
import com.caucho.server.resin.BootConfig;
import com.caucho.server.resin.BootResinConfig;
import com.caucho.server.resin.BootServerConfig;
import com.caucho.server.resin.ResinAdmin;
import com.caucho.server.resin.ResinArgs;
import com.caucho.server.resin.ResinConfig;
import com.caucho.server.resin.ResinDelegate;
import com.caucho.server.resin.ResinWaitForExitService;
import com.caucho.server.resin.StartInfoListener;
import com.caucho.util.CompileException;
import com.caucho.util.CurrentTime;
import com.caucho.util.HostUtil;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Resin {
    private static Logger _log;
    private static L10N _L;
    public static final int EXIT_OK = 0;
    private static final EnvironmentLocal<Resin> _resinLocal;
    private final ResinArgs _args;
    private final ResinSystem _resinSystem;
    private final String _serverId;
    private final String _displayServerId;
    private Path _resinHome;
    private Path _resinConf;
    private Path _confDirectory;
    private Path _rootDirectory;
    private Path _resinDataDirectory;
    private Path _serverDataDirectory;
    private Path _logDirectory;
    private String _homeCluster;
    private String _dynamicAddress;
    private int _dynamicPort;
    private String _localHostAddress;
    private String _clusterSystemKey;
    private String _stage = "production";
    private Socket _pingSocket;
    private ResinDelegate _resinDelegate;
    private BootConfig _bootConfig;
    private BootResinConfig _bootResinConfig;
    private BootServerConfig _bootServerConfig;
    private CloudServer _selfServer;
    private ServletContainerConfig _servletContainerConfig;
    private ServletService _servletSystem;
    private long _initialStartTime;
    private long _startTime;
    private ClassLoader _systemClassLoader;
    private Lifecycle _lifecycle;
    private Thread _mainThread;
    protected Management _management;
    private ResinAdmin _resinAdmin;
    private InputStream _waitIn;
    private boolean _isRestart;
    private String _restartMessage;
    private Path _licenseDirectory;
    private ResinWaitForExitService _waitForExitService;
    private final ArrayList<StartInfoListener> _startInfoListeners = new ArrayList();
    private boolean _isIgnoreLock;

    public Resin(String[] args) {
        this(new ResinArgs(args));
    }

    public Resin(ResinArgs args) {
        String serverId;
        this._startTime = CurrentTime.getCurrentTime();
        this._args = args;
        this._resinHome = args.getResinHome();
        this._resinConf = args.getResinConfPath();
        if (this._resinConf != null) {
            this._confDirectory = this._resinConf.getParent();
        }
        this._rootDirectory = args.getRootDirectory();
        this._resinDataDirectory = args.getDataDirectory();
        this._licenseDirectory = args.getLicenseDirectory();
        this._homeCluster = args.getHomeCluster();
        this._dynamicAddress = args.getServerAddress();
        this._dynamicPort = args.getServerPort();
        this._stage = args.getStage();
        this._pingSocket = this._args.getPingSocket();
        String displayServerId = args.getServerId();
        if (displayServerId == null || displayServerId.equals("")) {
            displayServerId = "default";
        }
        if (args.isElasticServer()) {
            serverId = args.getServerId();
            if (serverId == null || "".equals(serverId)) {
                serverId = "dyn";
                displayServerId = "dyn";
            }
            serverId = serverId + "-" + this.getDynamicServerAddress() + ':' + this.getDynamicServerPort();
        } else {
            serverId = displayServerId;
        }
        this._resinSystem = new ResinSystem(serverId);
        _resinLocal.set(this, this._resinSystem.getClassLoader());
        Environment.init();
        this._serverId = serverId;
        this._displayServerId = displayServerId;
        this.preConfigureInit();
        if (!this.isWatchdog()) {
            this.configureFile(this._resinConf);
        }
    }

    public void setIgnoreLock(boolean isIgnoreLock) {
        this._isIgnoreLock = isIgnoreLock;
        RootDirectorySystem subSystem = RootDirectorySystem.getCurrent();
        if (subSystem != null) {
            subSystem.setIgnoreLock(isIgnoreLock);
        }
    }

    public static Resin getCurrent() {
        return _resinLocal.get();
    }

    public ResinSystem getResinSystem() {
        return this._resinSystem;
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._resinSystem.getClassLoader();
    }

    ResinArgs getArgs() {
        return this._args;
    }

    public String getServerId() {
        return this._serverId;
    }

    public String getServerIdFilePart() {
        if (this._serverId == null || this._serverId.isEmpty()) {
            return "default";
        }
        return this._serverId.replace(':', '_');
    }

    public String getUniqueServerName() {
        String serverId = this.getDisplayServerId();
        String name = this.isWatchdog() ? serverId + "_watchdog" : serverId;
        name = name.replace('-', '_');
        return name;
    }

    public String getDisplayServerId() {
        return this._displayServerId;
    }

    public static String getCurrentServerId() {
        Resin resin = Resin.getCurrent();
        if (resin != null) {
            return resin.getServerId();
        }
        return "";
    }

    public boolean isResinServer() {
        return !this.isWatchdog();
    }

    public boolean isWatchdog() {
        return false;
    }

    public Path getResinConf() {
        return this._resinConf;
    }

    public Path getConfDirectory() {
        return this._confDirectory;
    }

    protected String getResinName() {
        return this.getDelegate().getResinName();
    }

    public Path getResinHome() {
        return this._resinHome;
    }

    public boolean isProfessional() {
        return this.getDelegate().isProfessional();
    }

    public boolean isEmbedded() {
        return false;
    }

    public Path getRootDirectory() {
        return this._rootDirectory;
    }

    public void setRootDirectory(Path path) {
        this._rootDirectory = path;
    }

    public Path getLicenseDirectory() {
        return this._licenseDirectory;
    }

    public void setLicenseDirectory(Path licenseDirectory) {
        this._licenseDirectory = licenseDirectory;
    }

    void setHomeCluster(String clusterId) {
        this._homeCluster = clusterId;
    }

    public String getHomeCluster() {
        if (this._homeCluster != null) {
            return this._homeCluster;
        }
        if (this._bootResinConfig != null) {
            return this._bootResinConfig.getHomeCluster();
        }
        return null;
    }

    public boolean isElasticServer() {
        return this._bootResinConfig.isElasticServer(this._args);
    }

    public String getClusterSystemKey() {
        return this._clusterSystemKey;
    }

    void setClusterSystemKey(String key) {
        this._clusterSystemKey = key;
    }

    public String getStage() {
        return this._stage;
    }

    public String getServerAddress() {
        return this._dynamicAddress;
    }

    public String getDynamicServerAddress() {
        String address = this.getServerAddress();
        if (address == null && this._bootConfig != null) {
            address = this._bootConfig.getBootResin().getElasticServerAddress(this._args);
        }
        if (address != null) {
            return address;
        }
        return this.getLocalHostAddress();
    }

    public int getServerPort() {
        return this._dynamicPort;
    }

    public int getDynamicServerPort() {
        int port = this.getServerPort();
        if (port > 0) {
            return port;
        }
        if (this._bootConfig != null && (port = this._bootConfig.getBootResin().getElasticServerPort(this._args)) > 0) {
            return port;
        }
        if (this._args.getElasticServerPort() > 0) {
            return this._args.getElasticServerPort();
        }
        return 6830;
    }

    public int getDynamicServerIndex() {
        int index = -1;
        if (index >= 0) {
            return index;
        }
        if (this._bootConfig != null && (index = this._bootConfig.getBootResin().getElasticServerIndex(this._args)) >= 0) {
            return index;
        }
        if (this._args.getElasticServerIndex() >= 0) {
            return this._args.getElasticServerIndex();
        }
        return -1;
    }

    public Path getLogDirectory() {
        if (this._logDirectory != null) {
            return this._logDirectory;
        }
        return this._rootDirectory.lookup("log");
    }

    public Path getResinDataDirectory() {
        Path path;
        Path root = this.getRootDirectory();
        if (this._resinDataDirectory != null) {
            root = this._resinDataDirectory;
        }
        if ((path = this.isWatchdog() ? root.lookup("watchdog-data") : root.lookup("resin-data")) instanceof MemoryPath) {
            path = WorkDir.getTmpWorkDir().lookup("qa/resin-data");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path getServerDataDirectory() {
        Resin resin = this;
        synchronized (resin) {
            Path dataDirectory = this.getResinDataDirectory();
            if (this._serverDataDirectory == null) {
                String serverName = this.getDisplayServerId();
                String dirPath = serverName = serverName.replace(':', '_');
                if (this.getDynamicServerPort() > 0 && dirPath.equals("dyn")) {
                    dirPath = dirPath + "-" + this.getDynamicServerPort();
                }
                this._serverDataDirectory = dataDirectory.lookup("./" + dirPath);
            }
        }
        return this._serverDataDirectory;
    }

    public Management createResinManagement() {
        if (this._management == null) {
            this._management = new Management(this);
        }
        return this._management;
    }

    public StatSystem createStatSystem() {
        return this.getDelegate().createStatSystem();
    }

    public LogSystem createLogSystem() {
        return this.getDelegate().createLogSystem();
    }

    public Date getInitialStartTime() {
        return new Date(this._initialStartTime);
    }

    public Date getStartTime() {
        return new Date(this._startTime);
    }

    public LifecycleState getLifecycleState() {
        return this._resinSystem.getLifecycleState();
    }

    public ServletService getServer() {
        return this._servletSystem;
    }

    public Management getManagement() {
        return this._management;
    }

    public CloudServer getSelfServer() {
        return this._selfServer;
    }

    public ServletService createServer() {
        if (this._servletSystem == null) {
            this.configure();
        }
        return this._servletSystem;
    }

    public boolean isActive() {
        return this._resinSystem.isActive();
    }

    public boolean isClosing() {
        return this._resinSystem.isDestroying();
    }

    public boolean isClosed() {
        return this._resinSystem.isStopped();
    }

    public void addStartInfoListener(StartInfoListener listener) {
        this._startInfoListeners.add(listener);
    }

    void setStartInfo(boolean isRestart, String startMessage, ExitCode exitCode) {
        this._isRestart = isRestart;
        this._restartMessage = startMessage;
        for (StartInfoListener listener : this._startInfoListeners) {
            listener.setStartInfo(isRestart, startMessage, exitCode);
        }
    }

    public boolean isRestart() {
        return this._isRestart;
    }

    public String getRestartMessage() {
        return this._restartMessage;
    }

    private void preConfigureInit() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClassLoader());
            _resinLocal.set(this, this.getClassLoader());
            this._lifecycle = new Lifecycle(Resin.log(), "Resin[]");
            if (this.getRootDirectory() == null) {
                throw new NullPointerException();
            }
            this._resinDelegate = ResinDelegate.create(this);
            this.getDelegate().addPreTopologyServices();
            if (!this.isWatchdog()) {
                this.initRepository();
            }
            if (!this.isWatchdog()) {
                Environment.addChildLoaderListener(new ListenerPersistenceEnvironment());
                Environment.addChildLoaderListener(new WebBeansAddLoaderListener());
                Environment.addChildLoaderListener(new EjbEnvironmentListener());
            }
            this.readUserProperties();
            Config.setProperty("rvar0", this.getDisplayServerId());
            this._bootConfig = new BootConfig(this._resinSystem, this.getDisplayServerId(), this.getResinHome(), this.getRootDirectory(), this.getLogDirectory(), this.getResinConf(), this.isProfessional(), this.isWatchdog() ? BootConfig.BootType.WATCHDOG : BootConfig.BootType.RESIN);
            this._bootResinConfig = this._bootConfig.getBootResin();
            this._resinAdmin = new ResinAdmin(this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private void readUserProperties() {
        if (this._args.getUserProperties() != null && this._args.getUserProperties().canRead()) {
            ResinProperties properties = new ResinProperties();
            properties.setPath(this._args.getUserProperties());
            properties.setMode(this._args.getMode());
            try {
                properties.init();
            }
            catch (Exception e) {
                Resin.log().info(e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (!this._lifecycle.toActive()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._resinSystem.getClassLoader());
            System.gc();
            this._servletSystem = this.createServer();
            ShutdownSystem shutdown = ShutdownSystem.getCurrent();
            shutdown.setShutdownWaitTime(this._servletSystem.getShutdownWaitMax());
            NetworkListenSystem listenService = this._resinSystem.getService(NetworkListenSystem.class);
            if (this._args != null) {
                for (ResinArgs.BoundPort port : this._args.getBoundPortList()) {
                    listenService.bind(port.getAddress(), port.getPort(), port.getServerSocket());
                }
            }
            this._resinSystem.start();
            Resin.log().info(this + " started in " + (CurrentTime.getExactTime() - this._startTime) + "ms");
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private void initRepository() {
        GitSystem.createAndAddService();
        LocalRepositoryService localRepositoryService = LocalRepositoryService.createAndAddService();
        RepositorySpi localRepository = localRepositoryService.getRepositorySpi();
        AbstractRepository repository = this.getDelegate().createRepository(localRepository);
        RepositorySystem.createAndAddService(repository);
        try {
            RepositoryScheme.create("cloud", this.getStage() + "/config/resin", this.getServerDataDirectory().lookup("config"));
        }
        catch (Exception e) {
            Resin.log().log(Level.WARNING, e.toString(), e);
        }
    }

    String getLocalHostAddress() {
        String localHostAddress = this._localHostAddress;
        if (localHostAddress == null) {
            this._localHostAddress = localHostAddress = this.getLocalHostAddressImpl();
        }
        return localHostAddress;
    }

    private String getLocalHostAddressImpl() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (addr.isLinkLocalAddress() || addr.isLoopbackAddress()) {
                addr = this.findLocalHost();
            }
            return addr.getHostAddress();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InetAddress findLocalHost() throws SocketException {
        for (NetworkInterface iface : HostUtil.getNetworkInterfaces()) {
            if (iface.isLoopback() || !iface.isUp()) continue;
            Enumeration<InetAddress> eInet = iface.getInetAddresses();
            while (eInet.hasMoreElements()) {
                InetAddress iAddr = eInet.nextElement();
                if (iAddr.isLinkLocalAddress() || iAddr.isLoopbackAddress()) continue;
                return iAddr;
            }
        }
        throw new ConfigException(Resin.L().l("Cannot find active interface for the server. Check the network configuration."));
    }

    public void stop() {
        this._resinSystem.stop();
    }

    public void destroy() {
        this._resinSystem.destroy();
    }

    public ResinAdmin getAdmin() {
        return this._resinAdmin;
    }

    public void initMain() throws Throwable {
        String licenseErrorMessage;
        this._mainThread = Thread.currentThread();
        this._mainThread.setContextClassLoader(this._systemClassLoader);
        System.out.println(VersionFactory.getFullVersion());
        System.out.println(VersionFactory.getCopyright());
        System.out.println();
        String licenseMessage = this.getDelegate().getLicenseMessage();
        if (licenseMessage != null) {
            Resin.log().warning(licenseMessage);
            System.out.println(licenseMessage);
        }
        if ((licenseErrorMessage = this.getDelegate().getLicenseErrorMessage()) != null) {
            System.err.println(licenseErrorMessage);
            System.err.flush();
            Resin.log().warning(licenseErrorMessage);
        }
        System.out.println("Starting " + this.getResinName() + " on " + QDate.formatLocal(this._startTime));
        System.out.println();
        Environment.init();
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(this._systemClassLoader);
        if (this._rootDirectory == null) {
            this._rootDirectory = this._resinHome;
        }
        this.configure();
        this.start();
    }

    private void configure() {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._resinSystem.getClassLoader());
            if (this._servletSystem == null) {
                BootResinConfig bootResin = this._bootResinConfig;
                this.configureRootDirectory(bootResin);
                this.initServletSystem();
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void configureFile(Path path) {
        this._bootConfig.configureFile(path);
    }

    public void configureProgram(ConfigProgram program) {
        program.configure(this._bootResinConfig);
    }

    private void configureRootDirectory(BootResinConfig bootConfig) throws IOException {
        Path dataDirectory = this.getServerDataDirectory();
        RootDirectorySystem system = RootDirectorySystem.createAndAddService(this._rootDirectory, dataDirectory);
        system.setIgnoreLock(this._isIgnoreLock);
    }

    private synchronized void initTopology() {
        if (this._selfServer != null) {
            return;
        }
        BootResinConfig bootResin = this._bootResinConfig;
        this._clusterSystemKey = bootResin.getClusterSystemKey();
        String serverId = this._serverId;
        if ("".equals(serverId)) {
            serverId = "default";
        }
        if (serverId != null) {
            this._bootServerConfig = bootResin.findServer(serverId);
        }
        if (serverId == null && !bootResin.isElasticServer(this._args)) {
            this._bootServerConfig = bootResin.findServer("default");
        }
        CloudSystem cloudSystem = bootResin.initTopology();
        if (this._bootServerConfig == null) {
            if (this.isEmbedded()) {
                this._bootServerConfig = this.joinEmbed();
            } else if (CurrentTime.isTest()) {
                this._bootServerConfig = this.joinTest();
            } else if (this.isWatchdog()) {
                this._bootServerConfig = this.joinWatchdog();
            } else {
                if (this._serverId != null && !this.isElasticServer()) {
                    throw new ConfigException(Resin.L().l("-server '{0}' is an unknown server in the configuration file.", (Object)this._serverId));
                }
                if (this.isElasticServer() || (this._bootServerConfig = bootResin.findLocalServer()) != null) {
                    // empty if block
                }
            }
        }
        if (this._bootServerConfig == null && this.isElasticServer()) {
            this._bootServerConfig = this.joinCluster(cloudSystem);
        }
        if (this._bootServerConfig == null) {
            throw new ConfigException(Resin.L().l("unknown server {0} in unknown cluster", (Object)this._serverId));
        }
        this._selfServer = cloudSystem.findServer(this._bootServerConfig.getId());
        if (this._selfServer == null) {
            throw new ConfigException(Resin.L().l("unexpected empty server '{0}'", (Object)this._bootServerConfig));
        }
        Config.setProperty("rvar0", this.getDisplayServerId());
        Config.setProperty("rvar1", this._selfServer.getCluster().getId());
        this.getDelegate().validateServerCluster();
    }

    private BootServerConfig joinCluster(CloudSystem cloudSystem) {
        BootResinConfig bootResin = this._bootResinConfig;
        String clusterId = this.getHomeCluster();
        BootClusterConfig bootCluster = bootResin.findCluster(clusterId);
        if (bootCluster == null) {
            throw new ConfigException(Resin.L().l("-cluster {0} is an unknown cluster.", (Object)clusterId));
        }
        CloudServer cloudServer = this.getDelegate().joinCluster(cloudSystem, bootCluster);
        if (cloudServer == null) {
            String cause = null;
            if (bootCluster.getPodList().isEmpty() || bootCluster.getPodList().get(0).getServerList().isEmpty()) {
                cause = Resin.L().l("No triad servers are configured in {0}.", (Object)bootCluster);
            } else {
                ArrayList<BootServerConfig> servers = bootCluster.getPodList().get(0).getServerList();
                boolean isFirst = true;
                StringBuilder sb = new StringBuilder();
                for (BootServerConfig server : servers) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    sb.append(server.getFullAddress());
                    isFirst = false;
                }
                cause = Resin.L().l("No triad servers were reachable.\n  Triad servers are {0}", (Object)sb);
            }
            throw new ConfigException(Resin.L().l("{0} unable to join cluster {1}: {2}", (Object)this.getDelegate(), (Object)clusterId, (Object)cause));
        }
        return bootCluster.addDynamicServer(cloudServer);
    }

    private BootServerConfig joinWatchdog() {
        BootResinConfig bootResin = this._bootResinConfig;
        BootClusterConfig bootCluster = bootResin.addClusterById("watchdog");
        BootServerConfig bootServer = bootCluster.createServer();
        bootServer.setId("default");
        bootServer.setAddress("127.0.0.1");
        bootCluster.addServer(bootServer);
        bootServer.initTopology();
        return bootServer;
    }

    private BootServerConfig joinTest() {
        BootClusterConfig bootCluster = this.findDefaultCluster();
        if (bootCluster.getPodList().size() != 0) {
            if (bootCluster.getPodList().get(0).getServerList().size() == 1) {
                return bootCluster.getPodList().get(0).getServerList().get(0);
            }
            if (bootCluster.getPodList().get(0).getServerList().size() > 0) {
                return null;
            }
        }
        BootServerConfig bootServer = bootCluster.createServer();
        bootServer.setId("default");
        bootServer.setAddress("127.0.0.1");
        bootCluster.addServer(bootServer);
        bootServer.initTopology();
        return bootServer;
    }

    private BootClusterConfig findDefaultCluster() {
        BootResinConfig bootResin = this._bootResinConfig;
        if (bootResin.getClusterList().size() == 1) {
            return bootResin.getClusterList().get(0);
        }
        return bootResin.findCluster("");
    }

    private BootServerConfig joinEmbed() {
        BootResinConfig bootResin = this._bootResinConfig;
        BootClusterConfig bootCluster = null;
        if (bootResin.getClusterList().size() == 1) {
            bootCluster = bootResin.getClusterList().get(0);
        }
        if (bootCluster == null) {
            bootCluster = bootResin.findCluster("");
        }
        if (bootCluster == null) {
            return null;
        }
        if (bootCluster.getPodList().size() != 0) {
            if (bootCluster.getPodList().get(0).getServerList().size() == 1) {
                BootServerConfig server = bootCluster.getPodList().get(0).getServerList().get(0);
                if (!server.isRequireExplicitId()) {
                    return server;
                }
                return null;
            }
            if (bootCluster.getPodList().get(0).getServerList().size() > 0) {
                return null;
            }
        }
        BootServerConfig bootServer = bootCluster.createServer();
        bootServer.setId("default");
        bootServer.setAddress("127.0.0.1");
        bootCluster.addServer(bootServer);
        bootServer.initTopology();
        return bootServer;
    }

    private void initClusterNetwork() {
        NetworkClusterSystem clusterSystem = this.getDelegate().createNetworkSystem(this._selfServer);
        NetworkClusterSystem.createAndAddService(clusterSystem);
        ClusterServer server = this._selfServer.getData(ClusterServer.class);
        if (server.getPort() == 0 && this.getServerPort() > 0) {
            server.setPort(this.getServerPort());
        }
        LoadBalanceService.createAndAddService(this.getDelegate().createLoadBalanceFactory());
        BamSystem.createAndAddService(server.getBamAdminName());
    }

    private void initServletSystem() throws IOException {
        if (this._servletSystem != null) {
            return;
        }
        this.initTopology();
        this.initClusterNetwork();
        this._servletSystem = this.getDelegate().createServer();
        if (this._args != null && this._args.getStage() != null) {
            this._servletSystem.setStage(this._args.getStage());
        } else if (this._stage != null) {
            this._servletSystem.setStage(this._stage);
        }
        NetworkListenSystem.createAndAddService(this._selfServer);
        DeployControllerService.createAndAddService();
        if (!this.isWatchdog()) {
            this.getDelegate().addServices();
        }
        ServletSystem.createAndAddService(this._servletSystem);
        ResinConfig resinConfig = new ResinConfig(this);
        BootResinConfig bootResin = this._bootResinConfig;
        bootResin.getProgram().configure(resinConfig);
        this._servletContainerConfig = new ServletContainerConfig(this._servletSystem);
        BootClusterConfig cluster = this._bootServerConfig.getPod().getCluster();
        cluster.getProgram().configure(this._servletContainerConfig);
        ServerConfig config = new ServerConfig(this._servletContainerConfig);
        cluster.getServerDefault().configure(config);
        this._bootServerConfig.getServerProgram().configure(config);
        this._servletContainerConfig.init();
        this._servletSystem.init();
    }

    ResinDelegate getDelegate() {
        return this._resinDelegate;
    }

    public LicenseStore getLicenseStore() {
        return this._resinDelegate.getLicenseStore();
    }

    public LicenseCheck getLicenseCheck() {
        return this._resinDelegate.getLicenseCheck();
    }

    protected boolean loadCloudLicenses() {
        try {
            Class<?> cl = Class.forName("com.caucho.cloud.license.LicenseClientImpl");
            LicenseClient client = (LicenseClient)cl.newInstance();
            Path licenses = this.getServerDataDirectory().lookup("licenses");
            return client.loadLicenses(licenses, this._selfServer.getPod());
        }
        catch (ClassNotFoundException e) {
            Resin.log().log(Level.ALL, e.toString(), e);
        }
        catch (Exception e) {
            Resin.log().log(Level.FINER, e.toString(), e);
        }
        return false;
    }

    public Broker getAdminBroker() {
        return this._management.getAdminBroker();
    }

    protected String getLicenseMessage() {
        return this.getDelegate().getLicenseMessage();
    }

    protected String getLicenseErrorMessage() {
        return this.getDelegate().getLicenseMessage();
    }

    public ServletContainerConfig getServletContainerConfig() {
        return this._servletContainerConfig;
    }

    public double getCpuLoad() {
        return 0.0;
    }

    public void waitForExit() throws IOException {
        this._waitForExitService = new ResinWaitForExitService(this, this._resinSystem, this._waitIn, this._pingSocket);
        this._waitForExitService.startResinActor();
        this._waitForExitService.waitForExit();
    }

    public void close() {
        Resin.log().info("Resin closed from the embedded server");
        this._resinSystem.destroy();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isProfessional()) {
            sb.append("Pro");
        }
        sb.append(this.getClass().getSimpleName());
        sb.append("[id=" + this.getDisplayServerId() + "]");
        return sb.toString();
    }

    public static void main(String[] argv) {
        try {
            Environment.init();
            Resin.validateEnvironment();
            Resin resin = new Resin(argv);
            resin.initMain();
            resin.getServer();
            resin.waitForExit();
            if (!resin.isClosing()) {
                ShutdownSystem.shutdownActive(ExitCode.FAIL_SAFE_HALT, "Resin shutdown from unknown reason");
            }
        }
        catch (Throwable e) {
            Throwable cause;
            e.printStackTrace();
            for (cause = e; cause != null && cause.getCause() != null && !(cause instanceof CompileException); cause = cause.getCause()) {
            }
            if (cause instanceof BindException) {
                System.err.println(e.getMessage());
                Resin.log().severe(e.toString());
                Resin.log().log(Level.FINE, e.toString(), e);
                System.exit(ExitCode.BIND.ordinal());
            } else if (e instanceof ConfigException) {
                System.err.println(e.getMessage());
                Resin.log().log(Level.CONFIG, e.toString(), e);
                System.exit(ExitCode.BAD_CONFIG.ordinal());
            } else {
                System.err.println(e.getMessage());
                Resin.log().log(Level.WARNING, e.toString(), e);
                e.printStackTrace(System.err);
            }
        }
        finally {
            System.exit(ExitCode.UNKNOWN.ordinal());
        }
    }

    private static void validateEnvironment() throws ConfigException {
        String loggingManager = System.getProperty("java.util.logging.manager");
        if (loggingManager == null || !loggingManager.equals("com.caucho.log.LogManagerImpl")) {
            Resin.log().warning(Resin.L().l("The following system property must be set:\n  -Djava.util.logging.manager=com.caucho.log.LogManagerImpl\nThe JDK 1.4 Logging manager must be set to Resin's log manager."));
        }
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(Resin.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(Resin.class.getName());
        }
        return _log;
    }

    static {
        _resinLocal = new EnvironmentLocal();
    }
}

